/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.customizer;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.croz.nrich.formconfiguration.api.customizer.FormConfigurationMappingCustomizer;
import net.croz.nrich.registry.data.constant.RegistryDataConstants;
import net.croz.nrich.registry.data.util.ClassLoadingUtil;

public class RegistryDataFormConfigurationMappingCustomizer
implements FormConfigurationMappingCustomizer {
    private final List<Class<?>> registryClassList;

    public void customizeConfigurationMapping(Map<String, Class<?>> formConfigurationMapping) {
        this.registerRegistryFormConfiguration(formConfigurationMapping);
    }

    private void registerRegistryFormConfiguration(Map<String, Class<?>> formConfigurationMap) {
        this.registryClassList.forEach(registryClass -> {
            String registryClassName = registryClass.getName();
            String registryCreateFormId = String.format("%s:::%s", registryClassName, "create");
            String registryUpdateFormId = String.format("%s:::%s", registryClassName, "update");
            formConfigurationMap.computeIfAbsent(registryCreateFormId, key -> this.resolveClassByPackage(registryClassName, "%sCreateRequest"));
            formConfigurationMap.computeIfAbsent(registryUpdateFormId, key -> this.resolveClassByPackage(registryClassName, "%sUpdateRequest"));
        });
    }

    private Class<?> resolveClassByPackage(String registryFullClassName, String requestClassNameFormat) {
        int indexOfLastPackage;
        ArrayList<String> registryClassNameList = new ArrayList<String>(Arrays.asList(registryFullClassName.split("\\.")));
        if (RegistryDataConstants.CLASS_NAME_SUFFIX_LIST_TO_REPLACE.contains(registryClassNameList.get(indexOfLastPackage = registryClassNameList.size() - 2))) {
            registryClassNameList.remove(registryClassNameList.get(indexOfLastPackage));
        }
        registryClassNameList.add(registryClassNameList.size() - 1, "request");
        String fullClassNameWithRequestPackage = String.join((CharSequence)".", registryClassNameList);
        return this.resolveClass(registryFullClassName, fullClassNameWithRequestPackage, requestClassNameFormat);
    }

    private Class<?> resolveClass(String fullClassName, String fullClassNameWithRequestPackage, String requestClassNameFormat) {
        List<String> classNameList = Arrays.asList(String.format(requestClassNameFormat, fullClassNameWithRequestPackage), String.format("%sRequest", fullClassNameWithRequestPackage), String.format(requestClassNameFormat, fullClassName), String.format("%sRequest", fullClassName), fullClassName);
        return ClassLoadingUtil.loadClassFromList(classNameList);
    }

    @ConstructorProperties(value={"registryClassList"})
    @Generated
    public RegistryDataFormConfigurationMappingCustomizer(List<Class<?>> registryClassList) {
        this.registryClassList = registryClassList;
    }
}

