/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.history.service;

import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import net.croz.nrich.registry.api.core.service.RegistryEntityFinderService;
import net.croz.nrich.registry.api.history.model.EntityWithRevision;
import net.croz.nrich.registry.api.history.model.RevisionInfo;
import net.croz.nrich.registry.api.history.request.ListRegistryHistoryRequest;
import net.croz.nrich.registry.api.history.service.RegistryHistoryService;
import net.croz.nrich.registry.core.model.PropertyWithType;
import net.croz.nrich.registry.core.model.RegistryDataConfiguration;
import net.croz.nrich.registry.core.model.RegistryDataConfigurationHolder;
import net.croz.nrich.registry.core.model.RegistryHistoryConfigurationHolder;
import net.croz.nrich.search.api.model.sort.SortDirection;
import net.croz.nrich.search.api.model.sort.SortProperty;
import net.croz.nrich.search.api.util.PageableUtil;
import net.croz.nrich.search.bean.MapSupportingDirectFieldAccessFallbackBeanWrapper;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditProperty;
import org.modelmapper.ModelMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultRegistryHistoryService
implements RegistryHistoryService {
    private final EntityManager entityManager;
    private final RegistryDataConfigurationHolder registryDataConfigurationHolder;
    private final RegistryHistoryConfigurationHolder registryHistoryConfigurationHolder;
    private final ModelMapper modelMapper;
    private final Map<Class<?>, ManagedType<?>> classManagedTypeMap;
    private final RegistryEntityFinderService registryEntityFinderService;

    public DefaultRegistryHistoryService(EntityManager entityManager, RegistryDataConfigurationHolder registryDataConfigurationHolder, RegistryHistoryConfigurationHolder registryHistoryConfigurationHolder, ModelMapper modelMapper, RegistryEntityFinderService registryEntityFinderService) {
        this.entityManager = entityManager;
        this.registryDataConfigurationHolder = registryDataConfigurationHolder;
        this.registryHistoryConfigurationHolder = registryHistoryConfigurationHolder;
        this.modelMapper = modelMapper;
        this.classManagedTypeMap = this.initializeManagedTypeMap(registryDataConfigurationHolder);
        this.registryEntityFinderService = registryEntityFinderService;
    }

    @Transactional(readOnly=true)
    public <T> Page<EntityWithRevision<T>> historyList(ListRegistryHistoryRequest request) {
        AuditQuery auditQuery = this.createAuditQuery(request);
        this.addOrder(auditQuery, request.getSortPropertyList());
        List resultList = auditQuery.setFirstResult(request.getPageNumber().intValue()).setMaxResults(request.getPageSize().intValue()).getResultList();
        List<EntityWithRevision<T>> entityWithRevisionList = this.convertToEntityRevisionList(resultList);
        Pageable pageable = PageableUtil.convertToPageable((Integer)request.getPageNumber(), (Integer)request.getPageSize());
        return PageableExecutionUtils.getPage(entityWithRevisionList, (Pageable)pageable, () -> this.executeCountQuery(this.createAuditQuery(request)));
    }

    private Map<Class<?>, ManagedType<?>> initializeManagedTypeMap(RegistryDataConfigurationHolder registryDataConfigurationHolder) {
        if (registryDataConfigurationHolder.getRegistryDataConfigurationList() == null) {
            return Collections.emptyMap();
        }
        return registryDataConfigurationHolder.getRegistryDataConfigurationList().stream().collect(Collectors.toMap(RegistryDataConfiguration::getRegistryType, registryDataConfiguration -> this.entityManager.getMetamodel().managedType(registryDataConfiguration.getRegistryType())));
    }

    private <T> AuditQuery createAuditQuery(ListRegistryHistoryRequest request) {
        Class<Object> type = this.registryDataConfigurationHolder.findRegistryConfigurationForClass(request.getClassFullName()).getRegistryType();
        AuditQuery auditQuery = AuditReaderFactory.get((EntityManager)this.entityManager).createQuery().forRevisionsOfEntity(type, false, true);
        if (request.getRegistryRecordId() != null) {
            this.addIdCondition(type, auditQuery, request.getRegistryRecordId());
        }
        return auditQuery;
    }

    private long executeCountQuery(AuditQuery auditQuery) {
        auditQuery.addProjection(AuditEntity.revisionNumber().count());
        return (Long)auditQuery.getSingleResult();
    }

    private <T> List<EntityWithRevision<T>> convertToEntityRevisionList(List<?> resultList) {
        List<?> objectResultList = resultList;
        return Optional.ofNullable(objectResultList).orElse(Collections.emptyList()).stream().map(value -> new EntityWithRevision(this.initializeEntitySingularAssociations(value[0]), this.convertToRevisionInfo(value[1], (RevisionType)value[2]))).collect(Collectors.toList());
    }

    private void addIdCondition(Class<?> type, AuditQuery auditQuery, Object id) {
        Map idParameterMap = this.registryEntityFinderService.resolveIdParameterMap(type, id);
        if (idParameterMap.size() == 1) {
            idParameterMap.forEach((key, value) -> auditQuery.add(AuditEntity.id().eq(value)));
        } else {
            idParameterMap.forEach((key, value) -> auditQuery.add(AuditEntity.property((String)key).eq(value)));
        }
    }

    private void addOrder(AuditQuery auditQuery, List<SortProperty> sortPropertyList) {
        if (CollectionUtils.isEmpty(sortPropertyList)) {
            return;
        }
        sortPropertyList.forEach(sortProperty -> {
            AuditProperty<?> auditProperty = this.resolveAuditProperty(sortProperty.getProperty());
            if (sortProperty.getDirection() == SortDirection.ASC) {
                auditQuery.addOrder(auditProperty.asc());
            } else {
                auditQuery.addOrder(auditProperty.desc());
            }
        });
    }

    private AuditProperty<?> resolveAuditProperty(String sortProperty) {
        PropertyWithType revisionProperty = this.findByName(sortProperty);
        AuditProperty auditProperty = "revisionNumber".equals(sortProperty) ? AuditEntity.revisionNumber() : ("revisionType".equals(sortProperty) ? AuditEntity.revisionType() : ("revisionTimestamp".equals(sortProperty) ? AuditEntity.revisionProperty((String)this.registryHistoryConfigurationHolder.getRevisionTimestampProperty().getOriginalName()) : (revisionProperty != null ? AuditEntity.revisionProperty((String)revisionProperty.getOriginalName()) : AuditEntity.property((String)sortProperty))));
        return auditProperty;
    }

    private RevisionInfo convertToRevisionInfo(Object revisionEntity, RevisionType revisionType) {
        MapSupportingDirectFieldAccessFallbackBeanWrapper directFieldAccessFallbackBeanWrapper = new MapSupportingDirectFieldAccessFallbackBeanWrapper(revisionEntity);
        Object revisionNumber = directFieldAccessFallbackBeanWrapper.getPropertyValue(this.registryHistoryConfigurationHolder.getRevisionNumberProperty().getOriginalName());
        Object revisionDate = directFieldAccessFallbackBeanWrapper.getPropertyValue(this.registryHistoryConfigurationHolder.getRevisionTimestampProperty().getOriginalName());
        Assert.isTrue((revisionNumber != null && revisionDate != null ? 1 : 0) != 0, (String)"Revision number or revision date are empty!");
        Instant revisionDateAsInstant = revisionDate instanceof Long ? Instant.ofEpochMilli((Long)revisionDate) : ((Date)revisionDate).toInstant();
        Map<String, Object> additionalRevisionPropertyMap = this.registryHistoryConfigurationHolder.getRevisionAdditionalPropertyList().stream().collect(Collectors.toMap(PropertyWithType::getName, propertyWithType -> directFieldAccessFallbackBeanWrapper.getPropertyValue(propertyWithType.getOriginalName())));
        return new RevisionInfo(Long.valueOf(revisionNumber.toString()), revisionDateAsInstant, revisionType.name(), additionalRevisionPropertyMap);
    }

    private <T> T initializeEntitySingularAssociations(T entity) {
        ManagedType<?> managedType = this.classManagedTypeMap.get(entity.getClass());
        MapSupportingDirectFieldAccessFallbackBeanWrapper mapSupportingDirectFieldAccessFallbackBeanWrapper = new MapSupportingDirectFieldAccessFallbackBeanWrapper(entity);
        managedType.getSingularAttributes().stream().filter(Attribute::isAssociation).forEach(attribute -> {
            String attributeName = attribute.getName();
            Object attributeValue = mapSupportingDirectFieldAccessFallbackBeanWrapper.getPropertyValue(attributeName);
            if (attributeValue == null) {
                return;
            }
            Object deProxiedValue = BeanUtils.instantiateClass((Class)attribute.getJavaType());
            this.modelMapper.map(attributeValue, deProxiedValue);
            mapSupportingDirectFieldAccessFallbackBeanWrapper.setPropertyValue(attributeName, deProxiedValue);
        });
        return entity;
    }

    private PropertyWithType findByName(String name) {
        return this.registryHistoryConfigurationHolder.getRevisionAdditionalPropertyList().stream().filter(value -> name.equals(value.getName())).findFirst().orElse(null);
    }
}

