/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.customizer;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.croz.nrich.formconfiguration.api.customizer.FormConfigurationMappingCustomizer;
import net.croz.nrich.registry.data.util.ClassLoadingUtil;

public class RegistryDataFormConfigurationMappingCustomizer
implements FormConfigurationMappingCustomizer {
    private final List<Class<?>> registryClassList;

    public void customizeConfigurationMapping(Map<String, Class<?>> formConfigurationMapping) {
        this.registerRegistryFormConfiguration(formConfigurationMapping);
    }

    private void registerRegistryFormConfiguration(Map<String, Class<?>> formConfigurationMap) {
        this.registryClassList.forEach(registryClass -> {
            String registryClassName = registryClass.getName();
            String registryCreateFormId = String.format("%s:::%s", registryClassName, "create");
            String registryUpdateFormId = String.format("%s:::%s", registryClassName, "update");
            if (formConfigurationMap.get(registryCreateFormId) == null) {
                Class<?> createClass = this.resolveClass(registryClassName, "%sCreateRequest");
                formConfigurationMap.put(registryCreateFormId, createClass);
            }
            if (formConfigurationMap.get(registryUpdateFormId) == null) {
                Class<?> updateClass = this.resolveClass(registryClassName, "%sUpdateRequest");
                formConfigurationMap.put(registryUpdateFormId, updateClass);
            }
        });
    }

    private Class<?> resolveClass(String classFullName, String classLoadingInitialPrefix) {
        List<String> classNameList = Arrays.asList(String.format(classLoadingInitialPrefix, classFullName), String.format("%sRequest", classFullName), classFullName);
        return ClassLoadingUtil.loadClassFromList(classNameList);
    }

    @ConstructorProperties(value={"registryClassList"})
    @Generated
    public RegistryDataFormConfigurationMappingCustomizer(List<Class<?>> registryClassList) {
        this.registryClassList = registryClassList;
    }
}

