/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.configuration.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import lombok.Generated;
import net.croz.nrich.registry.api.configuration.model.RegistryEntityConfiguration;
import net.croz.nrich.registry.api.configuration.model.RegistryGroupConfiguration;
import net.croz.nrich.registry.api.configuration.model.property.JavascriptType;
import net.croz.nrich.registry.api.configuration.model.property.RegistryPropertyConfiguration;
import net.croz.nrich.registry.api.configuration.service.RegistryConfigurationService;
import net.croz.nrich.registry.api.core.model.RegistryOverrideConfiguration;
import net.croz.nrich.registry.configuration.comparator.RegistryGroupConfigurationComparator;
import net.croz.nrich.registry.configuration.comparator.RegistryPropertyComparator;
import net.croz.nrich.registry.configuration.util.JavaToJavascriptTypeConversionUtil;
import net.croz.nrich.registry.core.model.PropertyWithType;
import net.croz.nrich.registry.core.model.RegistryGroupDefinitionHolder;
import net.croz.nrich.registry.core.model.RegistryHistoryConfigurationHolder;
import net.croz.nrich.registry.core.support.ManagedTypeWrapper;
import net.croz.nrich.registry.core.util.AnnotationUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.DefaultMessageSourceResolvable;

public class DefaultRegistryConfigurationService
implements RegistryConfigurationService {
    private final MessageSource messageSource;
    private final List<String> readOnlyPropertyList;
    private final RegistryGroupDefinitionHolder registryGroupDefinitionHolder;
    private final RegistryHistoryConfigurationHolder registryHistoryConfiguration;
    private final Map<Class<?>, RegistryOverrideConfiguration> registryOverrideConfigurationMap;

    @Cacheable(value={"nrich.registryConfiguration.cache"})
    public List<RegistryGroupConfiguration> fetchRegistryGroupConfigurationList() {
        ArrayList<RegistryGroupConfiguration> registryGroupConfigurationList = new ArrayList<RegistryGroupConfiguration>();
        List<RegistryPropertyConfiguration> registryPropertyHistoryConfigurationList = this.resolveHistoryPropertyList(this.registryHistoryConfiguration);
        this.registryGroupDefinitionHolder.getGroupDefinitionList().forEach(registryGroupDefinition -> {
            String registryGroupIdDisplayName = this.groupDisplayLabel(registryGroupDefinition.getRegistryGroupId());
            List configurationList = registryGroupDefinition.getRegistryEntityList().stream().map(managedType -> this.resolveRegistryConfiguration(registryGroupDefinition.getRegistryGroupId(), (ManagedTypeWrapper)managedType, registryPropertyHistoryConfigurationList)).sorted(Comparator.comparing(RegistryEntityConfiguration::getClassFullName)).collect(Collectors.toList());
            RegistryGroupConfiguration registryConfiguration = new RegistryGroupConfiguration(registryGroupDefinition.getRegistryGroupId(), registryGroupIdDisplayName, configurationList);
            registryGroupConfigurationList.add(registryConfiguration);
        });
        registryGroupConfigurationList.sort(new RegistryGroupConfigurationComparator(this.registryGroupDefinitionHolder.getGroupDisplayOrderList()));
        return registryGroupConfigurationList;
    }

    private RegistryEntityConfiguration resolveRegistryConfiguration(String groupId, ManagedTypeWrapper managedTypeWrapper, List<RegistryPropertyConfiguration> historyPropertyConfigurationList) {
        Class<?> entityType = managedTypeWrapper.getJavaType();
        RegistryOverrideConfiguration registryOverrideConfiguration = this.resolveRegistryOverrideConfiguration(entityType, this.registryOverrideConfigurationMap);
        String registryDisplayName = this.registryDisplayLabel(entityType);
        boolean isHistoryAvailable = registryOverrideConfiguration.isHistoryAvailable() || this.isAudited(entityType);
        List<RegistryPropertyConfiguration> registryPropertyConfigurationList = this.resolveRegistryPropertyListForType(managedTypeWrapper, registryOverrideConfiguration);
        List<RegistryPropertyConfiguration> registryEmbeddedIdPropertyConfigurationList = this.resolverEmbeddedIdPropertyConfigurationList(managedTypeWrapper, registryOverrideConfiguration);
        List<String> registryPropertyDisplayOrderList = Optional.ofNullable(registryOverrideConfiguration.getPropertyDisplayOrderList()).orElse(Collections.emptyList());
        registryPropertyConfigurationList.sort(new RegistryPropertyComparator(registryPropertyDisplayOrderList));
        return RegistryEntityConfiguration.builder().groupId(groupId).classFullName(entityType.getName()).name(entityType.getSimpleName()).displayName(registryDisplayName).propertyConfigurationList(registryPropertyConfigurationList).embeddedIdPropertyConfigurationList(registryEmbeddedIdPropertyConfigurationList).historyPropertyConfigurationList(historyPropertyConfigurationList).readOnly(registryOverrideConfiguration.isReadOnly()).creatable(registryOverrideConfiguration.isCreatable()).updateable(registryOverrideConfiguration.isUpdateable()).deletable(registryOverrideConfiguration.isDeletable()).isHistoryAvailable(isHistoryAvailable).isIdentifierAssigned(managedTypeWrapper.isIdentifierAssigned()).isIdClassIdentity(managedTypeWrapper.isIdClassIdentifier()).isEmbeddedIdentity(managedTypeWrapper.isEmbeddedIdentifier()).idClassPropertyNameList(managedTypeWrapper.getIdClassPropertyNameList()).build();
    }

    private List<RegistryPropertyConfiguration> resolveRegistryPropertyListForType(ManagedTypeWrapper managedTypeWrapper, RegistryOverrideConfiguration registryOverrideConfiguration) {
        Predicate<String> isIdAttributePredicate = attributeName -> attributeName.equals(managedTypeWrapper.getIdAttributeName()) || managedTypeWrapper.getIdClassPropertyNameList().contains(attributeName);
        return this.resolveManagedTypePropertyList((ManagedType<?>)managedTypeWrapper.getIdentifiableType(), managedTypeWrapper.getIdentifiableType().getJavaType(), null, isIdAttributePredicate, !managedTypeWrapper.isIdentifierAssigned(), registryOverrideConfiguration);
    }

    private List<RegistryPropertyConfiguration> resolverEmbeddedIdPropertyConfigurationList(ManagedTypeWrapper managedTypeWrapper, RegistryOverrideConfiguration registryOverrideConfiguration) {
        if (!managedTypeWrapper.isEmbeddedIdentifier()) {
            return Collections.emptyList();
        }
        return this.resolveManagedTypePropertyList((ManagedType<?>)managedTypeWrapper.getEmbeddableIdType(), managedTypeWrapper.getIdentifiableType().getJavaType(), managedTypeWrapper.getIdAttributeName(), attribute -> false, true, registryOverrideConfiguration);
    }

    private List<RegistryPropertyConfiguration> resolveManagedTypePropertyList(ManagedType<?> managedType, Class<?> entityType, String prefix, Predicate<String> isIdAttributePredicate, boolean isIdReadOnly, RegistryOverrideConfiguration registryOverrideConfiguration) {
        List ignoredPropertyList = Optional.ofNullable(registryOverrideConfiguration.getIgnoredPropertyList()).orElse(Collections.emptyList());
        List readOnlyOverridePropertyList = Optional.ofNullable(registryOverrideConfiguration.getNonEditablePropertyList()).orElse(Collections.emptyList());
        List nonSortablePropertyList = Optional.ofNullable(registryOverrideConfiguration.getNonSortablePropertyList()).orElse(Collections.emptyList());
        List nonSearchablePropertyList = Optional.ofNullable(registryOverrideConfiguration.getNonSearchablePropertyList()).orElse(Collections.emptyList());
        ArrayList<RegistryPropertyConfiguration> registryPropertyConfigurationList = new ArrayList<RegistryPropertyConfiguration>();
        managedType.getAttributes().forEach(attribute -> {
            Class<?> singularAssociationReferencedClass;
            if (this.shouldSkipAttribute(ignoredPropertyList, (Attribute<?, ?>)attribute)) {
                return;
            }
            String attributeName = prefix == null ? attribute.getName() : String.format("%s.%s", prefix, attribute.getName());
            Class attributeType = attribute.getJavaType();
            boolean isIdAttribute = isIdAttributePredicate.test(attributeName);
            boolean isSingularAssociation = attribute.isAssociation() && attribute instanceof SingularAttribute;
            Class<?> clazz = singularAssociationReferencedClass = isSingularAssociation ? this.resolveSingularAssociationReferencedClass((Attribute<?, ?>)attribute) : null;
            boolean isReadOnly = isIdAttribute ? isIdReadOnly : this.readOnlyPropertyList.contains(attributeName) || readOnlyOverridePropertyList.contains(attributeName);
            boolean isSortable = !nonSortablePropertyList.contains(attributeName);
            boolean isSearchable = !nonSearchablePropertyList.contains(attributeName);
            RegistryPropertyConfiguration registryPropertyConfiguration = this.resolveRegistryPropertyConfiguration(entityType.getName(), attributeType, attributeName, isIdAttribute, isSingularAssociation, singularAssociationReferencedClass, isReadOnly, isSortable, isSearchable);
            registryPropertyConfigurationList.add(registryPropertyConfiguration);
        });
        return registryPropertyConfigurationList;
    }

    private List<RegistryPropertyConfiguration> resolveHistoryPropertyList(RegistryHistoryConfigurationHolder registryHistoryConfiguration) {
        ArrayList<PropertyWithType> historyPropertyList = new ArrayList<PropertyWithType>();
        historyPropertyList.add(registryHistoryConfiguration.getRevisionNumberProperty());
        historyPropertyList.add(registryHistoryConfiguration.getRevisionTimestampProperty());
        historyPropertyList.add(registryHistoryConfiguration.getRevisionTypeProperty());
        historyPropertyList.addAll(registryHistoryConfiguration.getRevisionAdditionalPropertyList());
        return historyPropertyList.stream().map(propertyWithType -> this.resolveRegistryPropertyConfiguration("revisionEntity", propertyWithType.getType(), propertyWithType.getName(), false, false, null, true, true, false)).sorted(new RegistryPropertyComparator(registryHistoryConfiguration.getPropertyDisplayList())).collect(Collectors.toList());
    }

    private RegistryPropertyConfiguration resolveRegistryPropertyConfiguration(String entityTypePrefix, Class<?> attributeType, String attributeName, boolean isIdAttribute, boolean isSingularAssociation, Class<?> singularAssociationReferencedClass, boolean isReadOnly, boolean isSortable, boolean isSearchable) {
        JavascriptType javascriptType = JavaToJavascriptTypeConversionUtil.fromJavaType(attributeType);
        boolean isDecimal = JavaToJavascriptTypeConversionUtil.isDecimal(attributeType);
        String attributeDisplayName = this.convertToDisplayValue(attributeName);
        String formLabel = this.formLabel(entityTypePrefix, attributeType, attributeName, attributeDisplayName);
        String columnHeader = this.columnHeader(entityTypePrefix, attributeType, attributeName, attributeDisplayName);
        return RegistryPropertyConfiguration.builder().name(attributeName).originalType(attributeType.getName()).javascriptType(javascriptType).isDecimal(isDecimal).isSingularAssociation(isSingularAssociation).singularAssociationReferencedClass((String)Optional.ofNullable(singularAssociationReferencedClass).map(Class::getName).orElse(null)).isId(isIdAttribute).formLabel(formLabel).columnHeader(columnHeader).editable(!isReadOnly).searchable(isSearchable).sortable(isSortable).build();
    }

    private Class<?> resolveSingularAssociationReferencedClass(Attribute<?, ?> attribute) {
        return ((ManagedType)((SingularAttribute)attribute).getType()).getJavaType();
    }

    private String groupDisplayLabel(String groupId) {
        String[] groupMessageCodeList = new String[]{String.format("%s.registryGroupIdDisplayName", groupId)};
        DefaultMessageSourceResolvable messageSourceResolvable = new DefaultMessageSourceResolvable(groupMessageCodeList, groupId);
        return this.messageSource.getMessage((MessageSourceResolvable)messageSourceResolvable, LocaleContextHolder.getLocale());
    }

    private String registryDisplayLabel(Class<?> entityType) {
        String[] groupMessageCodeList = new String[]{String.format("%s.registryEntityDisplayName", entityType.getName())};
        DefaultMessageSourceResolvable messageSourceResolvable = new DefaultMessageSourceResolvable(groupMessageCodeList, entityType.getSimpleName());
        return this.messageSource.getMessage((MessageSourceResolvable)messageSourceResolvable, LocaleContextHolder.getLocale());
    }

    private String formLabel(String entityTypePrefix, Class<?> attributeType, String attributeName, String attributeDisplayName) {
        String[] messageCodeList = this.labelMessageCodeList(entityTypePrefix, attributeType, attributeName).toArray(new String[0]);
        DefaultMessageSourceResolvable messageSourceResolvable = new DefaultMessageSourceResolvable(messageCodeList, attributeDisplayName);
        return this.messageSource.getMessage((MessageSourceResolvable)messageSourceResolvable, LocaleContextHolder.getLocale());
    }

    private String columnHeader(String entityTypePrefix, Class<?> attributeType, String attributeName, String attributeDisplayName) {
        ArrayList<String> headerMessageCodeList = new ArrayList<String>();
        headerMessageCodeList.add(String.format("%s.%s.header", entityTypePrefix, attributeName));
        headerMessageCodeList.addAll(this.labelMessageCodeList(entityTypePrefix, attributeType, attributeName));
        DefaultMessageSourceResolvable messageSourceResolvable = new DefaultMessageSourceResolvable(headerMessageCodeList.toArray(new String[0]), attributeDisplayName);
        return this.messageSource.getMessage((MessageSourceResolvable)messageSourceResolvable, LocaleContextHolder.getLocale());
    }

    private List<String> labelMessageCodeList(String entityTypePrefix, Class<?> attributeType, String attributeName) {
        return Arrays.asList(String.format("%s.%s.label", entityTypePrefix, attributeName), String.format("%s.%s.label", attributeName, attributeType.getName()), String.format("default.%s.label", attributeType.getName()));
    }

    private boolean shouldSkipAttribute(List<String> entityIgnoredPropertyList, Attribute<?, ?> attribute) {
        return attribute.isCollection() || entityIgnoredPropertyList.contains(attribute.getName());
    }

    private boolean isAudited(Class<?> entityType) {
        return AnnotationUtil.isAnnotationPresent(entityType, "org.hibernate.envers.Audited");
    }

    private RegistryOverrideConfiguration resolveRegistryOverrideConfiguration(Class<?> type, Map<Class<?>, RegistryOverrideConfiguration> registryOverrideConfigurationMap) {
        if (registryOverrideConfigurationMap == null || registryOverrideConfigurationMap.get(type) == null) {
            return RegistryOverrideConfiguration.defaultConfiguration();
        }
        return registryOverrideConfigurationMap.get(type);
    }

    private String convertToDisplayValue(String attributeName) {
        List attributeWordList = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)attributeName)).map(value -> value.trim().toLowerCase(Locale.ROOT)).filter(value -> !".".equals(value)).collect(Collectors.toList());
        return StringUtils.capitalize((String)String.join((CharSequence)" ", attributeWordList));
    }

    @ConstructorProperties(value={"messageSource", "readOnlyPropertyList", "registryGroupDefinitionHolder", "registryHistoryConfiguration", "registryOverrideConfigurationMap"})
    @Generated
    public DefaultRegistryConfigurationService(MessageSource messageSource, List<String> readOnlyPropertyList, RegistryGroupDefinitionHolder registryGroupDefinitionHolder, RegistryHistoryConfigurationHolder registryHistoryConfiguration, Map<Class<?>, RegistryOverrideConfiguration> registryOverrideConfigurationMap) {
        this.messageSource = messageSource;
        this.readOnlyPropertyList = readOnlyPropertyList;
        this.registryGroupDefinitionHolder = registryGroupDefinitionHolder;
        this.registryHistoryConfiguration = registryHistoryConfiguration;
        this.registryOverrideConfigurationMap = registryOverrideConfigurationMap;
    }
}

