/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.croz.nrich.registry.api.data.service.RegistryDataFormConfigurationResolverService;
import net.croz.nrich.registry.data.util.ClassLoadingUtil;

public class DefaultRegistryDataFormConfigurationResolverService
implements RegistryDataFormConfigurationResolverService {
    private final List<Class<?>> registryClassList;
    private final Map<String, Class<?>> formConfigurationMap;

    public DefaultRegistryDataFormConfigurationResolverService(List<Class<?>> registryClassList, Map<String, Class<?>> formConfigurationMap) {
        this.registryClassList = registryClassList;
        this.formConfigurationMap = formConfigurationMap;
        this.registerRegistryFormConfiguration(formConfigurationMap);
    }

    public Map<String, Class<?>> resolveRegistryFormConfiguration() {
        return this.formConfigurationMap;
    }

    private void registerRegistryFormConfiguration(Map<String, Class<?>> formConfigurationMap) {
        this.registryClassList.forEach(registryClass -> {
            String registryClassName = registryClass.getName();
            String registryCreateFormId = String.format("%s:::%s", registryClassName, "create");
            String registryUpdateFormId = String.format("%s:::%s", registryClassName, "update");
            if (formConfigurationMap.get(registryCreateFormId) == null) {
                Class<?> createClass = this.resolveClass(registryClassName, "%sCreateRequest");
                formConfigurationMap.put(registryCreateFormId, createClass);
            }
            if (formConfigurationMap.get(registryUpdateFormId) == null) {
                Class<?> updateClass = this.resolveClass(registryClassName, "%sUpdateRequest");
                formConfigurationMap.put(registryUpdateFormId, updateClass);
            }
        });
    }

    private Class<?> resolveClass(String classFullName, String classLoadingInitialPrefix) {
        List<String> classNameList = Arrays.asList(String.format(classLoadingInitialPrefix, classFullName), String.format("%sRequest", classFullName), classFullName);
        return ClassLoadingUtil.loadClassFromList(classNameList);
    }
}

