/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.controller;

import java.beans.ConstructorProperties;
import java.util.Map;
import javax.validation.Valid;
import lombok.Generated;
import net.croz.nrich.registry.api.data.request.ListBulkRegistryRequest;
import net.croz.nrich.registry.api.data.request.ListRegistryRequest;
import net.croz.nrich.registry.api.data.service.RegistryDataService;
import net.croz.nrich.registry.data.request.CreateRegistryRequest;
import net.croz.nrich.registry.data.request.DeleteRegistryRequest;
import net.croz.nrich.registry.data.request.UpdateRegistryRequest;
import net.croz.nrich.registry.data.service.RegistryDataRequestConversionService;
import org.springframework.data.domain.Page;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"${croz.nrich.registry.domain:}/nrich/registry/data"})
@ResponseBody
public class RegistryDataController {
    private final RegistryDataService registryDataService;
    private final RegistryDataRequestConversionService registryDataRequestConversionService;
    private final Validator validator;

    @PostMapping(value={"list-bulk"})
    public Map<String, Page<?>> listBulk(@RequestBody @Valid ListBulkRegistryRequest request) {
        return this.registryDataService.listBulk(request);
    }

    @PostMapping(value={"list"})
    public <P> Page<P> list(@RequestBody @Valid ListRegistryRequest request) {
        return this.registryDataService.list(request);
    }

    @PostMapping(value={"delete"})
    public <T> T delete(@RequestBody @Valid DeleteRegistryRequest request) {
        return (T)this.registryDataService.delete(request.getClassFullName(), request.getId());
    }

    @PostMapping(value={"create"})
    public <T> T create(@RequestBody @Valid CreateRegistryRequest request) {
        Object entityData = this.registryDataRequestConversionService.convertEntityDataToTyped(request);
        this.validateEntityData(entityData);
        return (T)this.registryDataService.create(request.getClassFullName(), entityData);
    }

    @PostMapping(value={"update"})
    public <T> T update(@RequestBody @Valid UpdateRegistryRequest request) {
        Object entityData = this.registryDataRequestConversionService.convertEntityDataToTyped(request);
        this.validateEntityData(entityData);
        return (T)this.registryDataService.update(request.getClassFullName(), request.getId(), entityData);
    }

    private void validateEntityData(Object entityData) {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(entityData, "entityData");
        this.validator.validate(entityData, (Errors)errors);
        if (errors.hasErrors()) {
            throw new BindException((BindingResult)errors);
        }
    }

    @ConstructorProperties(value={"registryDataService", "registryDataRequestConversionService", "validator"})
    @Generated
    public RegistryDataController(RegistryDataService registryDataService, RegistryDataRequestConversionService registryDataRequestConversionService, Validator validator) {
        this.registryDataService = registryDataService;
        this.registryDataRequestConversionService = registryDataRequestConversionService;
        this.validator = validator;
    }
}

