/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.core.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import lombok.Generated;
import net.croz.nrich.registry.api.core.service.RegistryEntityFinderService;
import net.croz.nrich.registry.core.support.ManagedTypeWrapper;
import org.modelmapper.ModelMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EntityManagerRegistryEntityFinderService
implements RegistryEntityFinderService {
    private final EntityManager entityManager;
    private final ModelMapper modelMapper;
    private final Map<String, ManagedTypeWrapper> classNameManagedTypeWrapperMap;

    public <T> T findEntityInstance(Class<T> type, Object id) {
        QueryCondition queryCondition = this.queryWherePartWithParameterMap(type, id, true);
        String joinFetchQueryPart = this.classNameManagedTypeWrapperMap.get(type.getName()).getSingularAssociationList().stream().map(attribute -> String.format(" left join fetch entity.%s ", attribute.getName())).collect(Collectors.joining(" "));
        String entityWithAlias = String.format(" %s %s ", type.getName(), "entity");
        String querySelectPart = String.format(" %s %s ", entityWithAlias, joinFetchQueryPart.trim());
        String fullQuery = String.format("select entity from %s where %s", querySelectPart, queryCondition.wherePart);
        TypedQuery query = (TypedQuery)this.entityManager.createQuery(fullQuery);
        queryCondition.parameterMap.forEach((arg_0, arg_1) -> ((TypedQuery)query).setParameter(arg_0, arg_1));
        return (T)query.getSingleResult();
    }

    public <T> Map<String, Object> resolveIdParameterMap(Class<T> type, Object id) {
        return this.queryWherePartWithParameterMap(type, id, false).parameterMap;
    }

    private <T> QueryCondition queryWherePartWithParameterMap(Class<T> type, Object id, boolean convertParameterToQueryFormat) {
        ManagedTypeWrapper managedTypeWrapper = this.classNameManagedTypeWrapperMap.get(type.getName());
        ArrayList<String> wherePartList = new ArrayList<String>();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (managedTypeWrapper.isIdClassIdentifier()) {
            Assert.isTrue((boolean)(id instanceof Map), (String)"Id should be instance of Map for @IdClass identifier");
            Map<String, Object> idMap = ((Map)id).entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), Map.Entry::getValue));
            Map<String, Class<?>> idClassPropertyMap = managedTypeWrapper.getIdClassPropertyMap();
            idClassPropertyMap.forEach((key, value) -> {
                Object convertedIdValue = this.modelMapper.map(idMap.get(key), value);
                wherePartList.add(this.toParameterExpression((String)key, convertParameterToQueryFormat));
                parameterMap.put(this.toParameterVariable((String)key, convertParameterToQueryFormat), convertedIdValue);
            });
        } else {
            Object convertedIdValue;
            if (managedTypeWrapper.isEmbeddedIdentifier()) {
                Assert.isTrue((id instanceof Map || managedTypeWrapper.getEmbeddableIdType().getJavaType().equals(id.getClass()) ? 1 : 0) != 0, (String)"Id should be instance of Map or EmbeddedId for @EmbeddedId identifier");
                convertedIdValue = this.modelMapper.map(id, managedTypeWrapper.getEmbeddableIdType().getJavaType());
            } else {
                convertedIdValue = this.modelMapper.map(id, managedTypeWrapper.getIdentifiableType().getIdType().getJavaType());
            }
            String idAttributeName = managedTypeWrapper.getIdAttributeName();
            wherePartList.add(this.toParameterExpression(idAttributeName, convertParameterToQueryFormat));
            parameterMap.put(this.toParameterVariable(idAttributeName, convertParameterToQueryFormat), convertedIdValue);
        }
        return new QueryCondition(String.join((CharSequence)" and ", wherePartList), parameterMap);
    }

    private String toParameterExpression(String key, boolean convertParameterToQueryFormat) {
        return String.format("entity.%s = :%s", key, this.toParameterVariable(key, convertParameterToQueryFormat));
    }

    private String toParameterVariable(String key, boolean convertParameterToQueryFormat) {
        if (!convertParameterToQueryFormat) {
            return key;
        }
        String[] keyList = key.split("\\.");
        return Arrays.stream(keyList).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    @ConstructorProperties(value={"entityManager", "modelMapper", "classNameManagedTypeWrapperMap"})
    @Generated
    public EntityManagerRegistryEntityFinderService(EntityManager entityManager, ModelMapper modelMapper, Map<String, ManagedTypeWrapper> classNameManagedTypeWrapperMap) {
        this.entityManager = entityManager;
        this.modelMapper = modelMapper;
        this.classNameManagedTypeWrapperMap = classNameManagedTypeWrapperMap;
    }

    private static final class QueryCondition {
        private final String wherePart;
        private final Map<String, Object> parameterMap;

        @ConstructorProperties(value={"wherePart", "parameterMap"})
        @Generated
        public QueryCondition(String wherePart, Map<String, Object> parameterMap) {
            this.wherePart = wherePart;
            this.parameterMap = parameterMap;
        }

        @Generated
        public String getWherePart() {
            return this.wherePart;
        }

        @Generated
        public Map<String, Object> getParameterMap() {
            return this.parameterMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryCondition)) {
                return false;
            }
            QueryCondition other = (QueryCondition)o;
            String this$wherePart = this.getWherePart();
            String other$wherePart = other.getWherePart();
            if (this$wherePart == null ? other$wherePart != null : !this$wherePart.equals(other$wherePart)) {
                return false;
            }
            Map<String, Object> this$parameterMap = this.getParameterMap();
            Map<String, Object> other$parameterMap = other.getParameterMap();
            return !(this$parameterMap == null ? other$parameterMap != null : !((Object)this$parameterMap).equals(other$parameterMap));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $wherePart = this.getWherePart();
            result = result * 59 + ($wherePart == null ? 43 : $wherePart.hashCode());
            Map<String, Object> $parameterMap = this.getParameterMap();
            result = result * 59 + ($parameterMap == null ? 43 : ((Object)$parameterMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EntityManagerRegistryEntityFinderService.QueryCondition(wherePart=" + this.getWherePart() + ", parameterMap=" + this.getParameterMap() + ")";
        }
    }
}

