/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.data.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.croz.nrich.registry.core.model.RegistryDataConfigurationHolder;
import net.croz.nrich.registry.data.request.CreateRegistryRequest;
import net.croz.nrich.registry.data.request.UpdateRegistryRequest;
import net.croz.nrich.registry.data.service.RegistryDataRequestConversionService;
import net.croz.nrich.registry.data.util.ClassLoadingUtil;

public class DefaultRegistryDataRequestConversionService
implements RegistryDataRequestConversionService {
    private final ObjectMapper objectMapper;
    private final RegistryDataConfigurationHolder registryDataConfigurationHolder;

    @Override
    public Object convertEntityDataToTyped(CreateRegistryRequest request) {
        Class<?> type = this.resolveClassWithConfigurationVerification(request.getClassFullName(), "%sCreateRequest");
        return this.convertStringToInstance(request.getJsonEntityData(), type);
    }

    @Override
    public Object convertEntityDataToTyped(UpdateRegistryRequest request) {
        Class<?> type = this.resolveClassWithConfigurationVerification(request.getClassFullName(), "%sUpdateRequest");
        return this.convertStringToInstance(request.getJsonEntityData(), type);
    }

    private Class<?> resolveClassWithConfigurationVerification(String classFullName, String classLoadingInitialPrefix) {
        this.registryDataConfigurationHolder.verifyConfigurationExists(classFullName);
        List<String> classNameList = Arrays.asList(String.format(classLoadingInitialPrefix, classFullName), String.format("%sRequest", classFullName), classFullName);
        return ClassLoadingUtil.loadClassFromList(classNameList);
    }

    private Object convertStringToInstance(String entityData, Class<?> entityType) {
        return this.objectMapper.readValue(entityData, entityType);
    }

    @ConstructorProperties(value={"objectMapper", "registryDataConfigurationHolder"})
    @Generated
    public DefaultRegistryDataRequestConversionService(ObjectMapper objectMapper, RegistryDataConfigurationHolder registryDataConfigurationHolder) {
        this.objectMapper = objectMapper;
        this.registryDataConfigurationHolder = registryDataConfigurationHolder;
    }
}

