/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.registry.core.model;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.croz.nrich.registry.core.model.RegistryDataConfiguration;
import net.croz.nrich.registry.core.support.ManagedTypeWrapper;

public class RegistryDataConfigurationHolder {
    private final Map<String, ManagedTypeWrapper> classNameManagedTypeWrapperMap;
    private final List<RegistryDataConfiguration<?, ?>> registryDataConfigurationList;

    public void verifyConfigurationExists(String classFullName) {
        this.findRegistryConfigurationForClass(classFullName);
    }

    public RegistryDataConfiguration<?, ?> findRegistryConfigurationForClass(String classFullName) {
        return this.registryDataConfigurationList.stream().filter(configuration -> configuration.getRegistryType().getName().equals(classFullName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Configuration for registry entity %s is not defined!", classFullName)));
    }

    public ManagedTypeWrapper resolveManagedTypeWrapper(String className) {
        return this.classNameManagedTypeWrapperMap.get(className);
    }

    @ConstructorProperties(value={"classNameManagedTypeWrapperMap", "registryDataConfigurationList"})
    @Generated
    public RegistryDataConfigurationHolder(Map<String, ManagedTypeWrapper> classNameManagedTypeWrapperMap, List<RegistryDataConfiguration<?, ?>> registryDataConfigurationList) {
        this.classNameManagedTypeWrapperMap = classNameManagedTypeWrapperMap;
        this.registryDataConfigurationList = registryDataConfigurationList;
    }

    @Generated
    public Map<String, ManagedTypeWrapper> getClassNameManagedTypeWrapperMap() {
        return this.classNameManagedTypeWrapperMap;
    }

    @Generated
    public List<RegistryDataConfiguration<?, ?>> getRegistryDataConfigurationList() {
        return this.registryDataConfigurationList;
    }
}

