/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.notification.service;

import jakarta.validation.ConstraintViolation;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.croz.nrich.notification.api.service.ConstraintConversionService;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.beanvalidation.CustomValidatorBean;

public class DefaultConstraintConversionService
implements ConstraintConversionService {
    private final ValidatorConverter validatorConverter = new ValidatorConverter();

    public Object resolveTarget(Set<ConstraintViolation<?>> constraintViolationList) {
        return constraintViolationList.stream().map(ConstraintViolation::getLeafBean).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Errors convertConstraintViolationsToErrors(Set<ConstraintViolation<?>> constraintViolationList, Object target, String targetName) {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(target, targetName);
        Set<ConstraintViolation<Object>> convertedConstraintViolationList = constraintViolationList.stream().map(this::asObjectConstraintViolation).collect(Collectors.toSet());
        this.validatorConverter.processConstraintViolations(convertedConstraintViolationList, (Errors)errors);
        return errors;
    }

    private ConstraintViolation<Object> asObjectConstraintViolation(ConstraintViolation<?> constraintViolation) {
        return constraintViolation;
    }

    private static class ValidatorConverter
    extends CustomValidatorBean {
        private ValidatorConverter() {
        }

        public void processConstraintViolations(Set<ConstraintViolation<Object>> violations, Errors errors) {
            super.processConstraintViolations(violations, errors);
        }
    }
}

