/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.notification.service;

import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import net.croz.nrich.notification.api.model.AdditionalNotificationData;
import net.croz.nrich.notification.api.model.Notification;
import net.croz.nrich.notification.api.model.ValidationFailureNotification;
import net.croz.nrich.notification.api.response.NotificationDataResponse;
import net.croz.nrich.notification.api.response.NotificationResponse;
import net.croz.nrich.notification.api.service.NotificationResolverService;
import net.croz.nrich.notification.api.service.NotificationResponseService;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

public class WebMvcNotificationResponseService
implements NotificationResponseService {
    private final NotificationResolverService notificationResolverService;

    public NotificationResponse responseWithValidationFailureNotification(Errors errors, Class<?> validationFailedOwningType, AdditionalNotificationData additionalNotificationData) {
        ValidationFailureNotification notification = this.notificationResolverService.createNotificationForValidationFailure(errors, validationFailedOwningType, additionalNotificationData);
        return new NotificationResponse((Notification)notification);
    }

    public NotificationResponse responseWithValidationFailureNotification(ConstraintViolationException exception, AdditionalNotificationData additionalNotificationData) {
        ValidationFailureNotification notification = this.notificationResolverService.createNotificationForValidationFailure(exception, additionalNotificationData);
        return new NotificationResponse((Notification)notification);
    }

    public NotificationResponse responseWithExceptionNotification(Throwable throwable, AdditionalNotificationData additionalNotificationData, Object ... exceptionMessageArgumentList) {
        Notification notification = this.notificationResolverService.createNotificationForException(throwable, additionalNotificationData, exceptionMessageArgumentList);
        return new NotificationResponse(notification);
    }

    public NotificationResponse responseWithNotificationActionResolvedFromRequest(AdditionalNotificationData additionalNotificationData) {
        String actionName = this.extractActionNameFromCurrentRequest();
        return this.responseWithNotification(actionName, additionalNotificationData);
    }

    public NotificationResponse responseWithNotification(String actionName, AdditionalNotificationData additionalNotificationData) {
        Notification notification = this.notificationResolverService.createNotificationForAction(actionName, additionalNotificationData);
        return new NotificationResponse(notification);
    }

    public <D> NotificationDataResponse<D> responseWithNotificationActionResolvedFromRequest(D data, AdditionalNotificationData additionalNotificationData) {
        String actionName = this.extractActionNameFromCurrentRequest();
        return this.responseWithNotification(data, actionName, additionalNotificationData);
    }

    public <D> NotificationDataResponse<D> responseWithNotification(D data, String actionName, AdditionalNotificationData additionalNotificationData) {
        Notification notification = this.notificationResolverService.createNotificationForAction(actionName, additionalNotificationData);
        return new NotificationDataResponse(notification, data);
    }

    public NotificationResolverService notificationResolverService() {
        return this.notificationResolverService;
    }

    private String extractActionNameFromCurrentRequest() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        return this.extractActionNameFromRequest(request);
    }

    private String extractActionNameFromRequest(HttpServletRequest request) {
        String path = new UrlPathHelper().getPathWithinApplication(request);
        return path.substring(1).replace('/', '.');
    }

    @ConstructorProperties(value={"notificationResolverService"})
    @Generated
    public WebMvcNotificationResponseService(NotificationResolverService notificationResolverService) {
        this.notificationResolverService = notificationResolverService;
    }
}

