/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.notification.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.croz.nrich.notification.api.service.NotificationMessageResolverService;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class MessageSourceNotificationMessageResolverService
implements NotificationMessageResolverService {
    private final MessageSource messageSource;

    public String resolveMessage(List<String> messageCodeList, List<Object> argumentList, String defaultMessage) {
        Assert.notEmpty(messageCodeList, (String)"Code list cannot be empty!");
        Object[] arguments = argumentList == null ? new Object[]{} : argumentList.toArray(new Object[0]);
        DefaultMessageSourceResolvable messageSourceResolvable = new DefaultMessageSourceResolvable(messageCodeList.toArray(new String[0]), arguments, defaultMessage);
        return this.messageSource.getMessage((MessageSourceResolvable)messageSourceResolvable, LocaleContextHolder.getLocale());
    }

    public String resolveMessageForObjectError(Class<?> validationFailedOwningType, ObjectError objectError) {
        String constraintName = objectError.getCode();
        String fieldName = objectError instanceof FieldError ? ((FieldError)objectError).getField() : null;
        String name = validationFailedOwningType == null ? "" : StringUtils.uncapitalize((String)validationFailedOwningType.getName());
        String shortName = validationFailedOwningType == null ? "" : StringUtils.uncapitalize((String)validationFailedOwningType.getSimpleName());
        ArrayList<String> messageCodeList = new ArrayList<String>();
        if (fieldName == null) {
            messageCodeList.add(String.format("%s.%s.%s", name, constraintName, "invalid"));
            messageCodeList.add(String.format("%s.%s.%s", shortName, constraintName, "invalid"));
        } else {
            messageCodeList.add(String.format("%s.%s.%s.%s", name, fieldName, constraintName, "invalid"));
            messageCodeList.add(String.format("%s.%s.%s.%s", shortName, fieldName, constraintName, "invalid"));
            messageCodeList.add(String.format("%s.%s.%s", fieldName, constraintName, "invalid"));
        }
        messageCodeList.add(String.format("%s.%s", constraintName, "invalid"));
        String message = this.resolveMessage(messageCodeList, this.argumentsWithoutMessageCodeResolvable(objectError.getArguments()), objectError.getDefaultMessage());
        if (fieldName != null) {
            messageCodeList.clear();
            messageCodeList.add(String.format("%s.%s.%s", name, fieldName, "label"));
            messageCodeList.add(String.format("%s.%s.%s", shortName, fieldName, "label"));
            messageCodeList.add(String.format("%s.%s.%s", fieldName, constraintName, "label"));
            String fieldNameMessage = this.resolveMessage(messageCodeList, null, fieldName);
            message = String.format("%s: %s", fieldNameMessage, message);
        }
        return message;
    }

    private List<Object> argumentsWithoutMessageCodeResolvable(Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return Collections.emptyList();
        }
        Object[] filteredArguments = arguments;
        if (arguments[0] instanceof DefaultMessageSourceResolvable) {
            filteredArguments = Arrays.copyOfRange(arguments, 1, arguments.length);
        }
        return Arrays.stream(filteredArguments).map(value -> value instanceof Object[] ? this.convertToString((Object[])value) : value).collect(Collectors.toList());
    }

    private String convertToString(Object[] value) {
        return Arrays.toString(value).replace('[', ' ').replace(']', ' ').trim();
    }

    @ConstructorProperties(value={"messageSource"})
    @Generated
    public MessageSourceNotificationMessageResolverService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

