/*
 * Decompiled with CFR 0.152.
 */
package net.croz.nrich.notification.service;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import net.croz.nrich.notification.api.model.AdditionalNotificationData;
import net.croz.nrich.notification.api.model.Notification;
import net.croz.nrich.notification.api.model.NotificationSeverity;
import net.croz.nrich.notification.api.model.ValidationError;
import net.croz.nrich.notification.api.model.ValidationFailureNotification;
import net.croz.nrich.notification.api.service.NotificationMessageResolverService;
import net.croz.nrich.notification.api.service.NotificationResolverService;
import net.croz.nrich.notification.service.ConstraintConversionService;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class DefaultNotificationResolverService
implements NotificationResolverService {
    private final NotificationMessageResolverService notificationMessageResolverService;
    private final ConstraintConversionService constraintConversionService;

    public ValidationFailureNotification createNotificationForValidationFailure(Errors errors, Class<?> validationFailedOwningType, AdditionalNotificationData additionalNotificationData) {
        String title;
        String typeName = validationFailedOwningType == null ? null : validationFailedOwningType.getName();
        NotificationSeverity severity = Optional.ofNullable(additionalNotificationData.getSeverity()).orElse(NotificationSeverity.WARNING);
        if (typeName == null) {
            title = this.notificationMessageResolverService.resolveMessage(this.toList("notification.validation-failed.title"), "Validation failed");
        } else {
            String titleCode = String.format("%s.%s", typeName, "title");
            title = this.notificationMessageResolverService.resolveMessage(this.toList(titleCode, "notification.validation-failed.title"), "Validation failed");
        }
        String content = this.notificationMessageResolverService.resolveMessage(this.toList("notification.validation-failed.content"));
        List<ValidationError> validationErrorList = this.convertValidationErrorsToMessageList(errors, validationFailedOwningType);
        List<String> additionalNotificationDataMessageList = this.resolveMessageListFromNotificationData(additionalNotificationData.getMessageListDataMap());
        List validationMessageList = validationErrorList.stream().flatMap(value -> value.getErrorMessageList().stream()).collect(Collectors.toList());
        List messageList = Stream.concat(additionalNotificationDataMessageList.stream(), validationMessageList.stream()).collect(Collectors.toList());
        return new ValidationFailureNotification(title, content, messageList, severity, additionalNotificationData.getUxNotificationOptions(), validationErrorList);
    }

    public ValidationFailureNotification createNotificationForValidationFailure(ConstraintViolationException exception, AdditionalNotificationData additionalNotificationData) {
        Object target = this.constraintConversionService.resolveTarget(exception.getConstraintViolations());
        Errors errors = this.constraintConversionService.convertConstraintViolationsToErrors(exception.getConstraintViolations(), target, "UNKNOWN_VALIDATION_TARGET");
        Class targetClass = Optional.ofNullable(target).map(Object::getClass).orElse(null);
        return this.createNotificationForValidationFailure(errors, targetClass, additionalNotificationData);
    }

    public Notification createNotificationForException(Throwable throwable, AdditionalNotificationData additionalNotificationData, Object ... exceptionMessageArgumentList) {
        String typeName = throwable.getClass().getName();
        String titleCode = String.format("%s.%s", typeName, "title");
        String title = this.notificationMessageResolverService.resolveMessage(this.toList(titleCode, "notification.error-occurred.title"), "Error occurred");
        String contentCode = String.format("%s.%s", typeName, "content");
        String severityCode = String.format("%s.%s", typeName, "severity");
        String content = this.notificationMessageResolverService.resolveMessage(this.toList(contentCode, "notification.error-occurred.default-message"), this.toList(exceptionMessageArgumentList), null);
        NotificationSeverity severity = Optional.ofNullable(additionalNotificationData.getSeverity()).orElse(this.resolveExceptionSeverity(severityCode));
        List<String> messageList = this.resolveMessageListFromNotificationData(additionalNotificationData.getMessageListDataMap());
        return new Notification(title, content, messageList, severity, additionalNotificationData.getUxNotificationOptions());
    }

    public Notification createNotificationForAction(String actionName, AdditionalNotificationData additionalNotificationData) {
        String titleCode = String.format("%s.%s", actionName, "title");
        String contentCode = String.format("%s.%s", actionName, "content");
        String title = this.notificationMessageResolverService.resolveMessage(this.toList(titleCode, "notification.success.title"), "Action has been executed");
        String content = this.notificationMessageResolverService.resolveMessage(this.toList(contentCode, "notification.success.default-message"));
        NotificationSeverity severity = Optional.ofNullable(additionalNotificationData.getSeverity()).orElse(NotificationSeverity.INFO);
        List<String> messageList = this.resolveMessageListFromNotificationData(additionalNotificationData.getMessageListDataMap());
        return new Notification(title, content, messageList, severity, additionalNotificationData.getUxNotificationOptions());
    }

    private List<ValidationError> convertValidationErrorsToMessageList(Errors errors, Class<?> validationFailedOwningType) {
        LinkedHashMap<String, List> resultMap = new LinkedHashMap<String, List>();
        for (ObjectError objectError : errors.getAllErrors()) {
            String constraintFieldName = this.constraintFieldNameOrDefault(objectError);
            String message = this.notificationMessageResolverService.resolveMessageForObjectError(validationFailedOwningType, objectError);
            resultMap.computeIfAbsent(constraintFieldName, key -> new ArrayList());
            ((List)resultMap.get(constraintFieldName)).add(message);
        }
        return resultMap.entrySet().stream().map(value -> new ValidationError((String)value.getKey(), (List)value.getValue())).collect(Collectors.toList());
    }

    private List<String> resolveMessageListFromNotificationData(Map<String, ?> additionalNotificationData) {
        if (additionalNotificationData == null) {
            return Collections.emptyList();
        }
        return additionalNotificationData.entrySet().stream().map(this::resolveMessageForAdditionalData).filter(message -> !"UNDEFINED".equals(message)).collect(Collectors.toList());
    }

    private String constraintFieldNameOrDefault(ObjectError objectError) {
        return objectError instanceof FieldError ? ((FieldError)objectError).getField() : "CONTAINING_OBJECT";
    }

    private String resolveMessageForAdditionalData(Map.Entry<String, ?> additionalDataEntry) {
        String messageCode = String.format("notification.additional-data.%s.message", additionalDataEntry.getKey());
        return this.notificationMessageResolverService.resolveMessage(this.toList(messageCode), this.toList(additionalDataEntry.getValue()), "UNDEFINED");
    }

    private NotificationSeverity resolveExceptionSeverity(String messageCode) {
        String severityValue = this.notificationMessageResolverService.resolveMessage(this.toList(messageCode), NotificationSeverity.ERROR.name());
        return NotificationSeverity.valueOf((String)severityValue);
    }

    @SafeVarargs
    private final <T> List<T> toList(T ... codeList) {
        if (codeList == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(codeList);
    }

    @ConstructorProperties(value={"notificationMessageResolverService", "constraintConversionService"})
    @Generated
    public DefaultNotificationResolverService(NotificationMessageResolverService notificationMessageResolverService, ConstraintConversionService constraintConversionService) {
        this.notificationMessageResolverService = notificationMessageResolverService;
        this.constraintConversionService = constraintConversionService;
    }
}

