/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.testsuite;

import java.util.LinkedList;
import net.craftforge.essential.client.Client;
import net.craftforge.essential.client.ClientRequest;
import net.craftforge.essential.client.HttpClient;
import net.craftforge.essential.client.LocalClient;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.testsuite.RequestTestSuite;
import net.craftforge.essential.testsuite.environment.mocks.SimpleAuth;
import net.craftforge.essential.testsuite.environment.mocks.SimpleLog;
import org.junit.Before;
import org.junit.Test;

public abstract class ClientTest {
    private String address = "localhost";
    private int port = 8080;
    private String context = "/";
    private String packagePath = "net.craftforge.essential.testsuite.environment.services";
    private RequestTestSuite testSuite;

    protected void configureHttpClient(String address, int port, String context) {
        this.address = address;
        this.port = port;
        this.context = context;
    }

    protected void configureLocalClient(String packagePath) {
        this.packagePath = packagePath;
    }

    protected String getAddress() {
        return this.address;
    }

    protected int getPort() {
        return this.port;
    }

    protected String getContext() {
        return this.context;
    }

    protected String getPackagePath() {
        return this.packagePath;
    }

    protected String getLoggingProvider() {
        return SimpleLog.class.getName();
    }

    protected String getAuthenticationProvider() {
        return SimpleAuth.class.getName();
    }

    protected RequestTestSuite getTestSuite() {
        return this.testSuite;
    }

    @Before
    public void setUp() throws Exception {
        LinkedList<Client> clients = new LinkedList<Client>();
        Configuration config = new Configuration();
        config.setLoggingProvider(this.getLoggingProvider());
        config.setAuthenticationProvider(this.getAuthenticationProvider());
        clients.add((Client)new LocalClient(this.packagePath, config));
        clients.add((Client)new HttpClient("http://" + this.address + ":" + this.port + this.context));
        this.testSuite = new RequestTestSuite(clients);
    }

    @Test
    public void testBasics() throws Exception {
        ClientRequest request = new ClientRequest("GET", "/integration/simple/public");
        this.testSuite.runTest(request, HttpStatusCode.OK.getCode());
    }

    @Test
    public void testAuthentication() throws Exception {
        ClientRequest request = new ClientRequest("GET", "/integration/simple/mocks");
        request.setAuthorization("admin", "admin");
        this.testSuite.runTest(request, HttpStatusCode.OK.getCode());
    }
}

