/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.testsuite.environment.services;

import net.craftforge.essential.controller.annotations.Get;
import net.craftforge.essential.controller.annotations.Path;
import net.craftforge.essential.controller.annotations.Public;
import net.craftforge.essential.testsuite.environment.mocks.SimpleEntity;

/**
 * @author Christian Bick
 * @since 23.05.2011
 */
@Path("/integration/simple")
public class SimpleRequests {


    @Public @Get @Path("/public")
    public Object simple() {
        return new SimpleEntity("/integration/simple/public");
    }

    @Get @Path("/mocks")
    public Object basicAuth() {
        return new SimpleEntity("/integration/simple/mocks");
    }

}
