/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.context.spring.config.resolvers;

import java.io.InputStream;
import javax.inject.Inject;
import net.craftforge.essential.core.resolvers.BodyResolver;
import net.craftforge.essential.core.resolvers.DefaultBodyResolver;
import net.craftforge.essential.core.resolvers.DefaultHeaderResolver;
import net.craftforge.essential.core.resolvers.DefaultPathParamResolver;
import net.craftforge.essential.core.resolvers.DefaultQueryParamResolver;
import net.craftforge.essential.core.resolvers.HeaderMap;
import net.craftforge.essential.core.resolvers.HeaderResolver;
import net.craftforge.essential.core.resolvers.ParamMap;
import net.craftforge.essential.core.resolvers.PathParamMap;
import net.craftforge.essential.core.resolvers.PathParamResolver;
import net.craftforge.essential.core.resolvers.QueryParamMap;
import net.craftforge.essential.core.resolvers.QueryParamResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@Scope(value="request")
public class SpringRequestContentResolversConfig {
    @Inject
    private InputStream requestBody;
    @Inject
    private QueryParamMap queryParamMap;
    @Inject
    private PathParamMap pathParamMap;
    @Inject
    private HeaderMap headerMap;

    @Bean
    @Scope(value="request")
    public BodyResolver provideBodyResolver() {
        return new DefaultBodyResolver(this.requestBody);
    }

    @Bean
    @Scope(value="request")
    public HeaderResolver provideHeaderResolver() {
        return new DefaultHeaderResolver(this.headerMap);
    }

    @Bean
    @Scope(value="request")
    public QueryParamResolver provideParamMap() {
        return new DefaultQueryParamResolver((ParamMap)this.queryParamMap);
    }

    @Bean
    @Scope(value="request")
    public PathParamResolver providePathParamMap() {
        return new DefaultPathParamResolver(this.pathParamMap);
    }
}

