/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.context.spring.config.context;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.craftforge.essential.context.Context;
import net.craftforge.essential.context.Request;
import net.craftforge.essential.context.Response;
import net.craftforge.essential.context.servlet.ServletWebContext;
import net.craftforge.essential.context.servlet.ServletWebRequest;
import net.craftforge.essential.context.servlet.ServletWebResponse;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@Scope(value="request")
public class SpringContextConfig {
    @Inject
    private HttpServletRequest httpServletRequest;
    @Inject
    private HttpServletResponse httpServletResponse;
    @Inject
    private ServletContext servletContext;

    @Bean
    @Scope(value="request")
    public Request provideRequest() {
        return new ServletWebRequest(this.httpServletRequest);
    }

    @Bean
    @Scope(value="request")
    public Response provideResponse() {
        return new ServletWebResponse(this.httpServletResponse);
    }

    @Bean
    @Scope(value="request")
    public Context provideContext() {
        return new ServletWebContext(this.servletContext);
    }
}

