/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.context.spring;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.craftforge.essential.controller.Controller;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.core.constants.HttpStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringServlet
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(SpringServlet.class);

    public void service(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            Controller controller = (Controller)context.getBean(Controller.class);
            controller.perform();
        }
        catch (ControllerException e) {
            resp.setStatus(e.getHttpStatusCode().getCode());
            LOGGER.error("Controller failed to perform request", (Throwable)e);
        }
        catch (Throwable e) {
            resp.setStatus(HttpStatusCode.InternalServerError.getCode());
            LOGGER.error("Controller failed to perform request", e);
        }
    }
}

