/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring.config.resolvers;

import net.craftforge.essential.core.resolvers.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import javax.inject.Inject;
import java.io.InputStream;

/**
 * @author Christian Bick
 * @since 16.01.12
 */
@Configuration
@Scope("request")
public class SpringRequestContentResolversConfig {

    @Inject
    private InputStream requestBody;
    @Inject
    private QueryParamMap queryParamMap;
    @Inject
    private PathParamMap pathParamMap;
    @Inject
    private HeaderMap headerMap;

    @Bean
    @Scope("request")
    public BodyResolver provideBodyResolver() {
        return new DefaultBodyResolver(requestBody);
    }

    @Bean
    @Scope("request")
    public HeaderResolver provideHeaderResolver() {
        return new DefaultHeaderResolver(headerMap);
    }

    @Bean
    @Scope("request")
    public QueryParamResolver provideParamMap() {
        return new DefaultQueryParamResolver(queryParamMap);
    }

    @Bean
    @Scope("request")
    public PathParamResolver providePathParamMap() {
        return new DefaultPathParamResolver(pathParamMap);
    }
}
