/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring.config.providers;

import net.craftforge.essential.context.Request;
import net.craftforge.essential.controller.injection.QueryParameterProvider;
import net.craftforge.essential.controller.injection.RequestBodyProvider;
import net.craftforge.essential.controller.injection.RequestHeaderProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import javax.inject.Inject;

/**
 * @author Christian Bick
 * @since 16.01.12
 */
@Configuration
@Scope("request")
public class SpringRequestContentProvidersConfig {

    @Inject
    private Request request;

    @Bean
    @Scope("request")
    public RequestBodyProvider provideRequestBodyProvider() {
        return new RequestBodyProvider(request);
    }

    @Bean
    @Scope("request")
    public RequestHeaderProvider provideRequestHeaderProvider() {
        return new RequestHeaderProvider(request);
    }

    @Bean
    @Scope("request")
    public QueryParameterProvider provideRequestParameterProvider() {
        return new QueryParameterProvider(request);
    }

}
