/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring.config.context;

import net.craftforge.essential.context.Context;
import net.craftforge.essential.context.Request;
import net.craftforge.essential.context.Response;
import net.craftforge.essential.context.servlet.ServletWebContext;
import net.craftforge.essential.context.servlet.ServletWebRequest;
import net.craftforge.essential.context.servlet.ServletWebResponse;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Christian Bick
 * @since 16.01.12
 */
@Configuration
@Scope("request")
public class SpringContextConfig {

    @Inject
    private HttpServletRequest httpServletRequest;
    @Inject
    private HttpServletResponse httpServletResponse;
    @Inject
    private ServletContext servletContext;

    @Bean
    @Scope("request")
    public Request provideRequest() {
        return new ServletWebRequest(httpServletRequest);
    }

    @Bean
    @Scope("request")
    public Response provideResponse() {
        return new ServletWebResponse(httpServletResponse);
    }

    @Bean
    @Scope("request")
    public Context provideContext() {
        return new ServletWebContext(servletContext);
    }
}
