/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring.config;

import net.craftforge.essential.controller.allocation.ResourceTree;
import net.craftforge.essential.controller.injection.ResourceTreeProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import javax.inject.Inject;

/**
 * @author Christian Bick
 * @since 26.12.11
 */
@Configuration
@Scope("request")
public class SpringResourceTreeConfig {

    @Inject
    private ResourceTreeProvider resourceTreeProvider;

    @Bean
    @Scope("request")
    public ResourceTree provideResourceTree() {
        return resourceTreeProvider.get();
    }
}
