/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring.config;

import net.craftforge.essential.controller.injection.PathParameterProvider;
import net.craftforge.essential.controller.injection.QueryParameterProvider;
import net.craftforge.essential.controller.injection.RequestBodyProvider;
import net.craftforge.essential.controller.injection.RequestHeaderProvider;
import net.craftforge.essential.core.resolvers.HeaderMap;
import net.craftforge.essential.core.resolvers.PathParamMap;
import net.craftforge.essential.core.resolvers.QueryParamMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import javax.inject.Inject;
import java.io.InputStream;

/**
 * @author Christian Bick
 * @since 26.12.11
 */
@Configuration
@Scope("request")
public class SpringRequestContentConfig {

    @Inject
    private RequestBodyProvider requestBodyProvider;
    @Inject
    private RequestHeaderProvider requestHeaderProvider;
    @Inject
    private QueryParameterProvider queryParameterProvider;
    @Inject
    private PathParameterProvider pathParameterProvider;

    @Bean
    @Scope("request")
    public InputStream provideRequestBody() {
        return requestBodyProvider.get();
    }

    @Bean
    @Scope("request")
    public HeaderMap provideRequestHeaders() {
        return requestHeaderProvider.get();
    }

    @Bean
    @Scope("request")
    public QueryParamMap provideRequestParameters() {
        return queryParameterProvider.get();
    }

    @Bean
    @Scope("request")
    public PathParamMap provideRequestPathParameters() {
        return pathParameterProvider.get();
    }



}
