/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring;

import net.craftforge.essential.controller.Controller;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.core.constants.HttpStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Christian Bick
 * @since 26.12.11
 */
public class SpringServlet extends HttpServlet {

    private static Logger LOGGER = LoggerFactory.getLogger(SpringServlet.class);

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(getServletContext());
            Controller controller = context.getBean(Controller.class);
            controller.perform();
        } catch (ControllerException e) {
            resp.setStatus(e.getHttpStatusCode().getCode());
            LOGGER.error("Controller failed to perform request", e);
        } catch (Throwable e) {
            resp.setStatus(HttpStatusCode.InternalServerError.getCode());
            LOGGER.error("Controller failed to perform request", e);
        }
    }
}
