/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring;

import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author Christian Bick
 * @since 14.01.12
 */
@Component
public class SpringHttpServletResponseFilter implements Filter {

    private ThreadLocal<HttpServletResponse> responses = new ThreadLocal<HttpServletResponse>();

    public void init(FilterConfig filterConfig) throws ServletException { }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        responses.set(response);
        chain.doFilter(servletRequest, servletResponse);
        responses.remove();
    }

    /* Only to be used by the bean configuration */
    public HttpServletResponse getHttpServletResponse() {
        return responses.get();
    }

    public void destroy() { }


}
