/*
 * This file is part of essential.
 *
 *     essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with essential.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.craftforge.essential.context.spring;

import net.craftforge.essential.context.Application;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.inject.Inject;
import javax.servlet.ServletContext;

/**
 * @author Christian Bick
 * @since 04.01.12
 */
@Component
@Scope("request")
public class SpringApplication implements Application {

    private ServletContext servletContext;

    @Inject
    public SpringApplication(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Object provideInstance(Class<?> clazz) {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils
                .getRequiredWebApplicationContext(servletContext);
        return webApplicationContext.getBean(clazz);
    }
}
