CREATE TABLE zip
(zip_code INTEGER NOT NULL,
city VARCHAR(25),
state VARCHAR(2),
CONSTRAINT ZIP_PK PRIMARY KEY (zip_code));

CREATE TABLE customer
(customer_id INTEGER NOT NULL,
customer_name VARCHAR(25),
customer_email VARCHAR(40),
dob DATE,
customer_address VARCHAR(30),
zip_code INTEGER,
CONSTRAINT CUSTOMER_PK PRIMARY KEY (customer_id),
CONSTRAINT CUSTOMER_FK FOREIGN KEY (zip_code) REFERENCES zip (zip_code));

CREATE TABLE ordering
(order_id INTEGER NOT NULL,
order_date DATE,
customer_id INTEGER,
CONSTRAINT ORDER_PK PRIMARY KEY (order_id),
CONSTRAINT ORDER_FK FOREIGN KEY (customer_id) REFERENCES customer (customer_id));

CREATE TABLE product
(bar_code INTEGER NOT NULL,
product_quantity INTEGER,
varietal VARCHAR(30),
product_name VARCHAR(30),
description VARCHAR (300),
price INTEGER,
alcohol INTEGER,
appellation VARCHAR(50),
vintage INTEGER,
CONSTRAINT PRODUCT_PK PRIMARY KEY (bar_code));

CREATE TABLE order_line
(order_line_id INTEGER NOT NULL,
bar_code INTEGER,
order_id INTEGER,
order_quantity INTEGER,
CONSTRAINT ORDER_LINE_PK PRIMARY KEY (order_line_id),
CONSTRAINT ORDER_LINE_FK1 FOREIGN KEY (order_id) REFERENCES ordering(order_id),
CONSTRAINT ORDER_LINE_FK2 FOREIGN KEY (bar_code) REFERENCES product(bar_code));

CREATE TABLE supplier
(supplier_id INTEGER NOT NULL,
supplier_name VARCHAR(25),
supplier_email VARCHAR(40),
supplier_address VARCHAR(30),
zip_code INTEGER,
CONSTRAINT SUPPLIER_PK PRIMARY KEY (supplier_id),
CONSTRAINT SUPPLIER_FK FOREIGN KEY (zip_code) REFERENCES zip (zip_code));

CREATE TABLE shipment
(shipment_id INTEGER NOT NULL,
shipment_date DATE,
supplier_id INTEGER,
CONSTRAINT SHIPMENT_PK PRIMARY KEY (shipment_id),
CONSTRAINT SHIPMENT_FK FOREIGN KEY (supplier_id) REFERENCES supplier (supplier_id));







INSERT INTO zip (zip_code, city, state)
VALUES (32601, 'St. Paul', 'VA');
INSERT INTO zip (zip_code, city, state)
VALUES (94574, 'Hampton', 'NY');
INSERT INTO zip (zip_code, city, state)
VALUES (92115, 'San Diego', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (26559, 'Los Angeles', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (46887, 'Detroit', 'MI');
INSERT INTO zip (zip_code, city, state)
VALUES (33668, 'Cleveland', 'OH');
INSERT INTO zip (zip_code, city, state)
VALUES (11254, 'Sacramento', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (53421, 'Washington', 'WA');
INSERT INTO zip (zip_code, city, state)
VALUES (23445, 'Fairfield', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (19854, 'Maui', 'HA');
INSERT INTO zip (zip_code, city, state)
VALUES (56448, 'Springfield', 'MA');
INSERT INTO zip (zip_code, city, state)
VALUES (61237, 'Boston', 'MA');
INSERT INTO zip (zip_code, city, state)
VALUES (62738, 'Hometown', 'WI');
INSERT INTO zip (zip_code, city, state)
VALUES (92345, 'Houston', 'TX');
INSERT INTO zip (zip_code, city, state)
VALUES (23465, 'Ashland', 'OR');

INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (1, 'Greg Banks', 'gbanks@spamail.com', '1972-10-12', '2078 W. 17th St.', 32601);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (2, 'Kelly Slater', 'kslater@spamail.com', '1948-11-02', '1955 4th Ave.', 94574);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (3, 'John Deer', 'jdeer@spamail.com', '1939-12-10', '2665 Dove St.', 92115);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (4, 'Mohammad Oskoorouchi', 'moskoorouchi@spamail.com', '1954-09-03', '1514 Castelar St.', 26559);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (5, 'Monique Johnson', 'mjohnson@spamail.com', '1978-02-07', '2054 El Cajon Blvd.', 46887);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (6, 'Kimihiko Nakamura', 'knakamura@spamail.com', '1974-05-05', '188 University Ave.', 33668);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (7, 'Mason Dixon', 'mdixon@spamail.com', '1767-10-03', '6542 Hunt Ave.', 11254);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (8, 'Fred Cummings', 'fcummings@spamail.com', '1981-02-10', '1955 Allyn Ave.', 53421);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (9, 'Yi Sun', 'ysun@spamail.com', '1962-08-14', '1744 Jason St.', 23445);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (10,'Ernest Wendt', 'ewendt@spamail.com', '1958-09-03', '85 Spring St.', 19854);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (11,'Shaoyi He', 'she@spamail.com', '1962-01-19', '85 East Hwy.', 56448);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (12,'William Burns', 'wburns@spamail.com', '1955-07-17', '2233 Space St.', 61237);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (13,'Jack Leu', 'jleu@spamail.com', '1960-06-28', '4652 Mason Blvd.', 62738);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (14,'Jim Hamerly', 'jhamerly@spamail.com', '1959-03-29', '2386 First St.', 92345);
INSERT INTO customer (customer_id, customer_name, customer_email, dob, customer_address, zip_code)
VALUES (15,'Robert Aboolian', 'raboolian@spamail.com', '1955-04-01', '6687 Second Ave.', 23465);

INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1001, '2004-08-21', 1);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1002, '2004-09-16', 8);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1003, '2004-09-20', 15);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1004, '2004-10-04', 5);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1005, '2004-10-10', 3);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1006, '2004-10-13', 2);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1007, '2004-10-25', 11);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1008, '2004-10-30', 12);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1009, '2004-11-03', 4);
INSERT INTO ordering (order_id, order_date, customer_id)
VALUES (1010, '2004-11-06', 9);

INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (12113, 48, 'Merlot', 'Dynamite Vineyards Merlot', 'Explosive fruit flavors and intriguing aromas of plums, black cherries and spice.', 15.99, 13.5, 'California', 2001);
INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (23445, 24, 'Sangiovese', 'Louis Martini 1999 Sangiovese', 'Ripe, sweet, plummy nose that mingles with the varietal spice and an oak bouquet of Eastern European woods. Deep strawberry/raspberry fruit with citrus and cashew edges.', 14.99, 13.5, 'California', 1999);
INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (36748, 48, 'Pinot Noir', 'Acacia Beckstoffer Pinot Noir', 'Dark, healthy red. Superripe aromas of bitter cherry, flowers and cola, with a suggestion of aged steak.', 18.99, 12.5, 'Carneros, California', 2002);
INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (46247, 48, 'Chardonnay', 'Amberhill 2002 Chardonnay', 'Wonderful fruit flavors of peach, pear, and apple. Balanced by crisp acidity and soft oak in the finish.', 8.99, 13.3, 'California', 2002);
INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (53125, 12, 'Cabernet Sauvignon', 'Alexander Valley 2002 Cabernet', 'Dark and rich, this is a bottle that delivers.', 13.99, 13.4, 'California', 2002);
INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (66498, 96, 'Rosso', 'Coppola 2002 Rosso', 'Fancy and fruity, oh what a great wine it is.', 7.99, 11.2, 'California', 2002);
INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (71347, 24, 'Sauvignon Blanc', 'Kenwood 2002 Sauvignon Blanc', 'Bright and vibrant, fresh and crisp, boasting tropical fruit, pear and citrus flavors.', 7.99, 13.1, 'Napa Valley', 2002);
INSERT INTO product (bar_code, product_quantity, varietal, product_name, description, price, alcohol, appellation, vintage)
VALUES (83225, 12, 'Zinfandel', 'Buehler 2001 Zinfandel Napa', 'Zincredible! This mid to full-bodied zin has got some nice spice to it and will pair well with grilled foods.', 9.59, 13.8, 'Napa', 2001);

INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (1, 12113, 1001, 2);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (2, 23445, 1001, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (3, 36748, 1002, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (4, 12113, 1003, 3);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (5, 46247, 1004, 6);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (6, 12113, 1004, 2);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (7, 23445, 1004, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (8, 46247, 1005, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (9, 83225, 1006, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (10, 83225, 1007, 4);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (11, 12113, 1007, 6);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (12, 12113, 1007, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (13, 46247, 1008, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (14, 23445, 1008, 2);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (15, 71347, 1009, 3);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (16, 36748, 1009, 3);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (17, 53125, 1010, 1);
INSERT INTO order_line (order_line_id, bar_code, order_id, order_quantity)
VALUES (18, 71347, 1010, 2);

INSERT INTO zip (zip_code, city, state)
VALUES (91111, 'National City', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (91911, 'Chula Vista', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (92107, 'El Cajon', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (99210, 'San Diego', 'CA');
INSERT INTO zip (zip_code, city, state)
VALUES (99213, 'San Diego', 'CA');

INSERT INTO supplier (supplier_id, supplier_name, supplier_email, supplier_address, zip_code)
VALUES (1, 'Steve Wentzel', 'steve@hotmail.com', '3375 Naple st.', 99213);
INSERT INTO supplier (supplier_id, supplier_name, supplier_email, supplier_address, zip_code)
VALUES (2, 'Jeff Hanks', 'jh@hotmail.com', '1125 Palm St.', 99210);
INSERT INTO supplier (supplier_id, supplier_name, supplier_email, supplier_address, zip_code)
VALUES (3, 'Mike Metroyanis', 'mike@yahoo.com', '556 L St.', 92107);
INSERT INTO supplier (supplier_id, supplier_name, supplier_email, supplier_address, zip_code)
VALUES (4, 'Wilman Banks', 'wilman@gmail.com', '25116 Fletcher Dr.', 91911);
INSERT INTO supplier (supplier_id, supplier_name, supplier_email, supplier_address, zip_code)
VALUES (5, 'Peter Chestfield', 'Peter@hotmail.com', '4213 Broadway', 91111);

INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (1, '2004-08-05', 3);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (2, '2004-08-26', 1);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (3, '2004-09-01', 5);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (4, '2004-09-15', 2);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (5, '2004-09-20', 1);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (6, '2004-10-08', 4);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (7, '2004-10-11', 5);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (8, '2004-10-12', 2);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (9, '2004-11-08', 1);
INSERT INTO shipment (shipment_id, shipment_date, supplier_id)
VALUES (10, '2004-11-30', 3);