/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.example.persistence;

import java.util.regex.Pattern;
import org.hibernate.cfg.DefaultNamingStrategy;

public class DbNamingStrategy
extends DefaultNamingStrategy {
    public String classToTableName(String className) {
        if (className.isEmpty()) {
            return className;
        }
        String head = className.substring(0, 1);
        String tail = className.substring(1, className.length());
        className = head.toLowerCase() + tail;
        return this.camelCaseToUnderScore(className);
    }

    public String propertyToColumnName(String propertyName) {
        return this.camelCaseToUnderScore(propertyName);
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        return this.propertyToColumnName(referencedColumnName);
    }

    protected String camelCaseToUnderScore(String input) {
        return Pattern.compile("[A-Z]").matcher(input).replaceAll("_$0").toLowerCase();
    }
}

