/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.example.persistence;

import javax.persistence.EntityManager;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.reflection.managers.ReferenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrudDao<T> {
    private EntityManager em;

    public CrudDao(EntityManager entityManager) {
        this.em = entityManager;
    }

    public T createEntity(T entity) throws ControllerException {
        this.em.getTransaction().begin();
        this.em.persist(entity);
        this.em.getTransaction().commit();
        this.em.detach(entity);
        return (T)ReferenceManager.getInstance(entity.getClass()).nullifyActualReferences(entity);
    }

    public T updateEntity(Integer id, T entity) throws ControllerException {
        Object existingEntity = this.em.find(entity.getClass(), (Object)id);
        this.requireExistence(existingEntity);
        this.em.getTransaction().begin();
        Object result = this.em.merge(entity);
        this.em.getTransaction().commit();
        this.em.detach(result);
        return (T)ReferenceManager.getInstance(entity.getClass()).nullifyActualReferences(result);
    }

    public void deleteEntity(Class<T> clazz, Integer id) throws ControllerException {
        Object entity = this.em.find(clazz, (Object)id);
        this.requireExistence(entity);
        this.em.getTransaction().begin();
        this.em.remove(entity);
        this.em.getTransaction().commit();
    }

    public T readEntity(Class<T> clazz, Integer id) throws ControllerException {
        Object entity = this.em.find(clazz, (Object)id);
        this.requireExistence(entity);
        this.em.detach(entity);
        return (T)ReferenceManager.getInstance(clazz).nullifyActualReferences(entity);
    }

    protected void requireExistence(T entity) throws ControllerException {
        if (entity == null) {
            throw new ControllerException("Entity not found", HttpStatusCode.NotFound);
        }
    }
}

