/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.commons.database.memory;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import net.craftforge.commons.database.memory.InMemoryDb;
import net.craftforge.commons.database.memory.InMemoryUtils;
import org.hibernate.ejb.Ejb3Configuration;

public class InMemoryDbManager {
    private static ConcurrentHashMap<String, InMemoryDbManager> instances = new ConcurrentHashMap();
    private Ejb3Configuration configuration;
    private ConcurrentHashMap<String, InMemoryDb> inMemoryDatabasesCreated = new ConcurrentHashMap();
    private ConcurrentHashMap<String, InMemoryDb> inMemoryDatabasesInCreation = new ConcurrentHashMap();
    private final Object dbCreationMonitor = new Object();
    private String[] dbSetupStatements;

    public static InMemoryDbManager getInstance(String dbSetupScriptResource, Ejb3Configuration configuration) {
        instances.putIfAbsent(dbSetupScriptResource, new InMemoryDbManager(dbSetupScriptResource, configuration));
        return (InMemoryDbManager)instances.get(dbSetupScriptResource);
    }

    private InMemoryDbManager(String dbSetupScriptResource, Ejb3Configuration configuration) {
        this.configuration = configuration;
        try {
            this.dbSetupStatements = InMemoryUtils.getSqlStatementsFromResource((String)dbSetupScriptResource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InMemoryDb getInMemoryDb(String databaseName) {
        return this.getInMemoryDb(databaseName, 3600000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryDb getInMemoryDb(String databaseName, long timeout, long timeoutCheckInterval) {
        if (!this.inMemoryDatabasesCreated.containsKey(databaseName)) {
            InMemoryDb inMemoryDbInCreation;
            Object object = this.dbCreationMonitor;
            synchronized (object) {
                if (this.inMemoryDatabasesCreated.containsKey(databaseName)) {
                    return (InMemoryDb)this.inMemoryDatabasesCreated.get(databaseName);
                }
                if (this.inMemoryDatabasesInCreation.containsKey(databaseName)) {
                    inMemoryDbInCreation = (InMemoryDb)this.inMemoryDatabasesInCreation.get(databaseName);
                } else {
                    inMemoryDbInCreation = new InMemoryDb(this, databaseName, timeout, timeoutCheckInterval);
                    inMemoryDbInCreation.start();
                    this.inMemoryDatabasesInCreation.put(databaseName, inMemoryDbInCreation);
                }
            }
            inMemoryDbInCreation.waitForCreationCompleted();
            object = this.dbCreationMonitor;
            synchronized (object) {
                this.inMemoryDatabasesCreated.putIfAbsent(databaseName, inMemoryDbInCreation);
                this.inMemoryDatabasesInCreation.remove(databaseName);
            }
        }
        return (InMemoryDb)this.inMemoryDatabasesCreated.get(databaseName);
    }

    public boolean existsInMemoryDb(String databaseName) {
        return this.inMemoryDatabasesCreated.containsKey(databaseName) || this.inMemoryDatabasesInCreation.containsKey(databaseName);
    }

    public Ejb3Configuration getConfiguration() {
        return this.configuration;
    }

    protected String[] getDbSetupStatements() {
        return this.dbSetupStatements;
    }

    protected void removeInMemoryDb(String databaseName) {
        this.inMemoryDatabasesCreated.remove(databaseName);
    }
}

