/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.commons.database.memory;

import java.sql.DriverManager;
import java.sql.SQLException;
import javax.persistence.EntityManagerFactory;
import net.craftforge.commons.database.memory.InMemoryDbManager;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.ejb.Ejb3Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDb
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(InMemoryDb.class);
    public static final long DEFAULT_INITIAL_TIMEOUT = 3600000L;
    public static final long DEFAULT_TIMEOUT_CHECK_INTERVAL = 10000L;
    private final Object creationCompleted = new Object();
    private boolean databaseCreated = false;
    private String databaseName;
    private long timeoutCheckInterval;
    private long timeToTimeout;
    private long timeout;
    private InMemoryDbManager manager;
    private EntityManagerFactory entityManagerFactory;

    protected InMemoryDb(InMemoryDbManager manager, String databaseName, long timeout, long timeoutCheckInterval) {
        this.manager = manager;
        this.databaseName = databaseName;
        this.timeout = timeout;
        this.timeToTimeout = timeout;
        this.timeoutCheckInterval = timeoutCheckInterval;
    }

    public void run() {
        this.setupDatabase();
        this.waitForTimeout();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        this.timeToTimeout = this.timeout;
        return this.entityManagerFactory;
    }

    protected boolean waitForCreationCompleted() {
        Object object = this.creationCompleted;
        synchronized (object) {
            if (this.databaseCreated) {
                return true;
            }
            try {
                if (this.getState().equals((Object)Thread.State.NEW)) {
                    this.start();
                    this.creationCompleted.wait();
                    return false;
                }
                this.creationCompleted.wait();
                return false;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupDatabase() {
        logger.info("Setting up database {}", (Object)this.databaseName);
        SessionFactory sessionFactory = this.buildSessionFactory();
        Session session = sessionFactory.openSession();
        session.getTransaction().begin();
        this.executeStatements((org.hibernate.Session)session, this.manager.getDbSetupStatements());
        session.getTransaction().commit();
        logger.info("Database {} set up", (Object)this.databaseName);
        session.close();
        this.entityManagerFactory = this.buildEntityManagerFactory();
        Object object = this.creationCompleted;
        synchronized (object) {
            this.databaseCreated = true;
            this.creationCompleted.notifyAll();
        }
    }

    protected void waitForTimeout() {
        while (this.timeToTimeout > 0L) {
            try {
                Thread.sleep(this.timeoutCheckInterval);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.timeToTimeout -= this.timeoutCheckInterval;
        }
        this.destroyDatabase();
    }

    protected void destroyDatabase() {
        block3: {
            logger.info("Destroying database {}", (Object)this.databaseName);
            try {
                DriverManager.getConnection("jdbc:derby:memory:" + this.databaseName + ";drop=true");
            }
            catch (SQLException e) {
                SQLException nextException = e;
                boolean isExpectedException = false;
                while (nextException != null && !isExpectedException) {
                    isExpectedException = e.getMessage().contains("dropped");
                    nextException = e.getNextException();
                }
                if (isExpectedException) break block3;
                throw new RuntimeException("Failed to destroy database", e);
            }
        }
        logger.info("Database {} destroyed", (Object)this.databaseName);
        this.manager.removeInMemoryDb(this.databaseName);
    }

    protected EntityManagerFactory buildEntityManagerFactory() {
        Ejb3Configuration cfg = this.manager.getConfiguration();
        cfg.setProperty("hibernate.connection.url", "jdbc:derby:memory:" + this.databaseName + ";create=true");
        return cfg.buildEntityManagerFactory();
    }

    protected SessionFactory buildSessionFactory() {
        Configuration cfg = new Configuration();
        cfg.setProperty("hibernate.connection.url", "jdbc:derby:memory:" + this.databaseName + ";create=true");
        return cfg.buildSessionFactory();
    }

    protected void executeStatements(org.hibernate.Session session, String[] statements) {
        for (String statement : statements) {
            if (statement.isEmpty()) continue;
            session.createSQLQuery(statement).executeUpdate();
        }
    }
}

