/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.example.servlets;

import net.craftforge.essential.context.servlet.EssentialHttpServlet;
import net.craftforge.essential.controller.Configuration;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;

/**
 * <b>A front servlet extends the default essential http servlet by
 * overriding the controller configuration creation.</b>
 *
 *
 * @author Christian Bick
 * @since 07.08.11
 */
public class FrontServlet extends EssentialHttpServlet {

    private static Logger logger = LoggerFactory.getLogger(FrontServlet.class);

    /**
     * Gets the controller configuration from the given HTTP servlet.
     * Assigns a database for the requesting remote host depending
     * on its client host name. The resulting database name is then
     * set as a configuration property which can be accessed by
     * resources via @Property("databaseName").
     *
     * @param servletRequest The http servlet request
     * @return The controller configuration
     */
    @Override
    protected Configuration getControllerConfiguration(HttpServletRequest servletRequest) {
        String clientName = servletRequest.getRemoteHost();
        String databaseName = new String(Base64.encodeBase64(clientName.getBytes())).replace("=", "");
        logger.info("Assigning database {} for client {}", databaseName, clientName);
        Configuration configuration = new Configuration();
        configuration.setProperty("databaseName", databaseName);
        return configuration;
    }
}
