/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.example.resources.bindings;

import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.annotations.*;

/**
 * @author Christian Bick
 * @since 22.05.2011
 */
public interface CrudBinding<T> {

    @Post
    public T create(@Body T input) throws ControllerException;

    @Put
    @Path("/{id}")
    public T update(@Param("{id}") Integer id, @Body T input) throws ControllerException;

    @Get
    @Path("/{id}")
    public T read(@Param("{id}") Integer id) throws ControllerException;

    @Delete
    @Path("/{id}")
    public void delete(@Param("{id}") Integer id) throws ControllerException;
}
