/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.example.resources;

import net.craftforge.essential.controller.annotations.Property;
import net.craftforge.essential.example.persistence.CrudDao;
import net.craftforge.essential.example.persistence.EntityManagerProvider;

import javax.persistence.EntityManager;

/**
 * A persistent resource has access to an entity manager and other
 * convenient data access objects.
 *
 * @author Christian Bick
 * @since 30.08.11
 */
public class PersistentResource<T> {

    @Property("databaseName")
    private String databaseName;

    protected CrudDao<T> getCrudDao() {
        return new CrudDao<T>(createEntityManager());
    }

    protected EntityManager createEntityManager() {
        return EntityManagerProvider.createEntityManager(databaseName);
    }

}
