/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.example.resources;

import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.annotations.Path;
import net.craftforge.essential.example.model.OrderLine;
import net.craftforge.essential.example.resources.bindings.CrudBinding;

/**
 * @author Christian Bick
 * @since 09.08.11
 */
@Path("/orderline")
public class OrderLineResource extends PersistentResource<OrderLine> implements CrudBinding<OrderLine> {

    @SuppressWarnings("unused")
    public OrderLine create(OrderLine entity) throws ControllerException {
        return getCrudDao().createEntity(entity);
    }

    @SuppressWarnings("unused")
    public OrderLine update(Integer id, OrderLine entity) throws ControllerException {
        return getCrudDao().updateEntity(id, entity);
    }

    @SuppressWarnings("unused")
    public OrderLine read(Integer id) throws ControllerException {
        return getCrudDao().readEntity(OrderLine.class, id);
    }

    @SuppressWarnings("unused")
    public void delete(Integer id) throws ControllerException {
        getCrudDao().deleteEntity(OrderLine.class, id);
    }
}
