/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.essential.example.persistence;

import net.craftforge.commons.database.memory.InMemoryDbManager;
import net.craftforge.essential.example.config.ResourceConfig;
import net.craftforge.essential.example.model.*;
import org.hibernate.ejb.Ejb3Configuration;

import javax.persistence.EntityManager;

/**
 * This class provides the entity managers associated to the
 * in-memory database manager responsible for the example
 * database.
 *
 * @author Christian Bick
 * @since 15.08.11
 */
public class EntityManagerProvider {

    /**
     * Creates an entity manager for the given database name. Uses an in-memory
     * database manager to obtain the entity manager of the associated database.
     *
     * @param databaseName The database name
     * @return The entity manager
     */
    public static EntityManager createEntityManager(String databaseName) {
        Ejb3Configuration config = createConfiguration();
        InMemoryDbManager manager = InMemoryDbManager.getInstance(ResourceConfig.DB_SETUP_SCRIPT_RESOURCE, config);
        return manager.getInMemoryDb(databaseName).getEntityManagerFactory().createEntityManager();
    }

    /**
     * Creates an EJB3 configuration holding the class bindings and naming strategy.
     *
     * @return The EJB3 configuration
     */
    public static Ejb3Configuration createConfiguration() {
        Ejb3Configuration cfg = new Ejb3Configuration();
        cfg.setNamingStrategy(new DbNamingStrategy());
        cfg.addAnnotatedClass(Customer.class);
        cfg.addAnnotatedClass(Ordering.class);
        cfg.addAnnotatedClass(OrderLine.class);
        cfg.addAnnotatedClass(Product.class);
        cfg.addAnnotatedClass(Shipment.class);
        cfg.addAnnotatedClass(Supplier.class);
        cfg.addAnnotatedClass(Zip.class);
        return cfg;
    }

}
