/*
 * This file is part of essential (http://essential.craftforge.net).
 *
 *     Essential is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Essential is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2011 Christian Bick.
 */

package net.craftforge.commons.database.memory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * The in-memory utils provide common algorithms for in-memory
 * database management.
 *
 * @author Christian Bick
 * @since 04.08.11
 */
public class InMemoryUtils {

    /**
     * Gets the SQL statements from an SQL script.
     *
     * @param sqlScriptResource The SQL script resource
     * @return The SQL statements
     * @throws IOException if the resource loading fails
     */
    public static String[] getSqlStatementsFromResource(String sqlScriptResource) throws IOException {
        InputStream is = InMemoryUtils.class.getResourceAsStream(sqlScriptResource);
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        char[] buf = new char[1024];
        int numRead;
        while((numRead=reader.read(buf)) != -1){
            String readData = String.valueOf(buf, 0, numRead);
            sb.append(readData);
            buf = new char[1024];
        }
        reader.close();
        String[] statements = sb.toString().split(";");
        return trimAll(statements);
    }

    private static String[] trimAll(String[] unTrimmed) {
        String[] trimmed = new String[unTrimmed.length];
        for (int i = 0; i <unTrimmed.length; i++) {
            trimmed[i] = unTrimmed[i].trim();
        }
        return trimmed;
    }

}
