/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.reflection.utils;

import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflUtils {
    public static Class<?> primitiveToObject(Class<?> primitiveClass) {
        Class objectClass = primitiveClass.equals(Boolean.TYPE) ? Boolean.class : (primitiveClass.equals(Byte.TYPE) ? Byte.class : (primitiveClass.equals(Short.TYPE) ? Short.class : (primitiveClass.equals(Integer.TYPE) ? Integer.class : (primitiveClass.equals(Long.TYPE) ? Long.class : (primitiveClass.equals(Double.TYPE) ? Double.class : (primitiveClass.equals(Float.TYPE) ? Float.class : (primitiveClass.equals(Character.TYPE) ? Character.class : primitiveClass)))))));
        return objectClass;
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || c.equals(Boolean.class) || c.equals(Character.class) || c.equals(Short.class) || c.equals(Integer.class) || c.equals(Byte.class) || c.equals(Long.class) || c.equals(Double.class) || c.equals(Float.class);
    }

    public static boolean isVirtualPrimitive(Class<?> c) {
        return ReflUtils.isPrimitive(c) || String.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c);
    }

    public static boolean isActualReference(Class<?> c) {
        return !ReflUtils.isVirtualPrimitive(c);
    }

    public static boolean isCollection(Class<?> c) {
        return Collection.class.isAssignableFrom(c);
    }

    public static boolean isSingleVirtualPrimitive(Field field) {
        return !ReflUtils.isCollection(field.getType()) && !ReflUtils.isActualReference(field.getType());
    }

    public static boolean isSingleActualReference(Field field) {
        return !ReflUtils.isCollection(field.getType()) && ReflUtils.isActualReference(field.getType());
    }

    public static boolean isCollectionData(Field field) {
        return false;
    }

    public static boolean isCollectionReference(Field field) {
        return ReflUtils.isCollection(field.getType());
    }

    public static String getterName(String fieldName) {
        String first_lc = fieldName.substring(0, 1);
        String first_uc = first_lc.toUpperCase();
        fieldName = first_uc + fieldName.substring(1, fieldName.length());
        return "get" + fieldName;
    }

    public static String setterName(String fieldName) {
        String first_lc = fieldName.substring(0, 1);
        String first_uc = first_lc.toUpperCase();
        fieldName = first_uc + fieldName.substring(1, fieldName.length());
        return "set" + fieldName;
    }

    public static <T> Collection<T> createCollection(Class<?> collectionType) {
        if (collectionType.equals(Collection.class)) {
            return new ArrayList();
        }
        if (collectionType.equals(List.class)) {
            return new ArrayList();
        }
        if (collectionType.equals(Set.class)) {
            return new HashSet();
        }
        if (collectionType.equals(Queue.class)) {
            return new LinkedList();
        }
        return null;
    }
}

