/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.reflection.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.craftforge.reflection.utils.ReflUtils;

public class PropertyUtils {
    public static Object setProperty(Object owner, Field field, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (Modifier.isPublic(field.getModifiers())) {
            field.set(owner, value);
        } else {
            try {
                Method setter = owner.getClass().getMethod(ReflUtils.setterName(field.getName()), field.getType());
                setter.invoke(owner, value);
            }
            catch (NoSuchMethodException e) {
                field.setAccessible(true);
                field.set(owner, value);
                field.setAccessible(false);
            }
        }
        return owner;
    }

    public static Object getProperty(Object owner, Field field) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (Modifier.isPublic(field.getModifiers())) {
            return field.get(owner);
        }
        Method getter = owner.getClass().getMethod(ReflUtils.getterName(field.getName()), new Class[0]);
        return getter.invoke(owner, new Object[0]);
    }
}

