/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.reflection.utils;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageUtils {
    public static List<Class<?>> findClasses(String packageName) {
        ArrayList classes = new ArrayList();
        try {
            ClassLoader classLoader = PackageUtils.class.getClassLoader();
            assert (classLoader != null);
            String packagePath = PackageUtils.nameToPath(packageName);
            Enumeration<URL> resources = classLoader.getResources(packagePath);
            while (resources.hasMoreElements()) {
                URL resourceUrl = resources.nextElement();
                if (resourceUrl.getProtocol().equals("jar")) {
                    JarURLConnection con = (JarURLConnection)resourceUrl.openConnection();
                    JarFile jarFile = con.getJarFile();
                    classes.addAll(PackageUtils.findClassesInJar(jarFile, packagePath));
                    continue;
                }
                File directory = new File(resourceUrl.toURI());
                classes.addAll(PackageUtils.findClassesInDir(directory, packageName));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to initialize a class during package scan", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read a class file during package scan", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to convert resource URL to file path", e);
        }
        return classes;
    }

    public static List<Class<?>> findClassesInDir(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(PackageUtils.findClassesInDir(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static List<Class<?>> findClassesInJar(JarFile jarFile, String packagePath) throws ClassNotFoundException, IOException {
        ArrayList classes = new ArrayList();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (!jarEntry.getName().startsWith(packagePath) || !jarEntry.getName().endsWith(".class")) continue;
            String className = PackageUtils.pathToName(jarEntry.getName().substring(0, jarEntry.getName().length() - 6));
            classes.add(Class.forName(className));
        }
        return classes;
    }

    public static String nameToPath(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String pathToName(String packagePath) {
        return packagePath.replace('/', '.');
    }
}

