/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.reflection.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    public static List<Class<?>> getClassHierarchy(Class<?> c) {
        ArrayList classHierarchy = new ArrayList();
        for (Class<?> next = c; next != null && !next.equals(Object.class); next = next.getSuperclass()) {
            classHierarchy.add(next);
        }
        return classHierarchy;
    }

    public static List<Class<?>> getInterfaceHierarchy(Class<?> c) {
        ArrayList interfaceHierarchy = new ArrayList();
        for (Class<?> directInterface : c.getInterfaces()) {
            interfaceHierarchy.add(directInterface);
            if (directInterface.getInterfaces().length <= 0) continue;
            interfaceHierarchy.addAll(ClassUtils.getInterfaceHierarchy(directInterface));
        }
        return interfaceHierarchy;
    }

    public static Method getFirstImplementation(Class<?> c, Method method) {
        for (Class<?> candidateClass : ClassUtils.getClassHierarchy(c)) {
            for (Method candidateMethod : candidateClass.getDeclaredMethods()) {
                if (!ClassUtils.isMethodExchangeableBy(method, candidateMethod)) continue;
                return candidateMethod;
            }
        }
        return null;
    }

    public static boolean isMethodExchangeableBy(Method method, Method candidateMethod) {
        if (!method.getName().equals(candidateMethod.getName())) {
            return false;
        }
        Class<?>[] params = method.getParameterTypes();
        Class<?>[] candidateParams = candidateMethod.getParameterTypes();
        Type[] genericParams = method.getGenericParameterTypes();
        Type[] genericCandidateParams = candidateMethod.getGenericParameterTypes();
        if (params.length != candidateParams.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            Class<?> candidateParam = candidateParams[i];
            Type genericParam = genericParams[i];
            Type genericCandidateParam = genericCandidateParams[i];
            if (genericCandidateParam instanceof TypeVariableImpl && param.equals(Object.class)) {
                return false;
            }
            if (genericParam instanceof TypeVariableImpl && candidateParam.equals(Object.class)) {
                return false;
            }
            if (candidateParam.equals(param) || genericCandidateParam instanceof TypeVariableImpl || genericParam instanceof TypeVariableImpl) continue;
            return false;
        }
        return true;
    }
}

