/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.reflection.managers;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.craftforge.reflection.managers.ClassManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceManager.class);
    private static ConcurrentMap<String, ReferenceManager> instances = new ConcurrentHashMap<String, ReferenceManager>();
    private ClassManager classManager;

    public static <T> ReferenceManager<T> getInstance(Class<T> clazz) {
        if (!instances.containsKey(clazz.getName())) {
            LOGGER.debug("[Reference manager initialization] {}" + clazz.getName());
            instances.putIfAbsent(clazz.getName(), new ReferenceManager<T>(clazz));
        }
        return (ReferenceManager)instances.get(clazz.getName());
    }

    private ReferenceManager(Class<T> clazz) {
        this.classManager = ClassManager.getInstance(clazz);
    }

    public T nullifyActualReferences(T object) {
        for (Field field : this.classManager.getActualReferences()) {
            field.setAccessible(true);
            try {
                field.set(object, null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return object;
    }
}

