/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.reflection.managers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.craftforge.reflection.utils.ClassUtils;
import net.craftforge.reflection.utils.ReflUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassManager.class);
    private static ConcurrentMap<String, ClassManager> instances = new ConcurrentHashMap<String, ClassManager>();
    private final Object monitor = new Object();
    private Class<?> clazz;
    private List<Class<?>> classHierarchy;
    private List<Class<?>> interfaceHierarchy;
    private List<Field> actualReferences;
    private List<Field> virtualPrimitives;
    private List<Class<?>> completeClassHierarchy;
    private List<Method> allMethods;
    private ConcurrentMap<Field, ConcurrentMap<String, Annotation>> propertyAnnotations = new ConcurrentHashMap<Field, ConcurrentMap<String, Annotation>>();
    private ConcurrentMap<Method, ConcurrentMap<String, Annotation>> methodAnnotations = new ConcurrentHashMap<Method, ConcurrentMap<String, Annotation>>();
    private ConcurrentMap<Method, ConcurrentMap<String, Annotation[][]>> methodParameterAnnotations = new ConcurrentHashMap<Method, ConcurrentMap<String, Annotation[][]>>();
    private ConcurrentMap<String, Annotation> allTypeAnnotations = new ConcurrentHashMap<String, Annotation>();
    private ConcurrentMap<String, List<Method>> allAnnotatedMethods = new ConcurrentHashMap<String, List<Method>>();
    private ConcurrentMap<String, List<Field>> allAnnotatedProperties = new ConcurrentHashMap<String, List<Field>>();
    private ConcurrentMap<String, List<Method>> allGetterMethods;
    private ConcurrentMap<String, List<Method>> allSetterMethods;

    public static ClassManager getInstance(Field field) {
        return ClassManager.getInstance(field.getDeclaringClass());
    }

    public static ClassManager getInstance(Method method) {
        return ClassManager.getInstance(method.getDeclaringClass());
    }

    public static ClassManager getInstance(Class<?> clazz) {
        if (!instances.containsKey(clazz.getName())) {
            LOGGER.debug("[Class manager initialization] {}", (Object)clazz.getName());
            instances.putIfAbsent(clazz.getName(), new ClassManager(clazz));
        }
        return (ClassManager)instances.get(clazz.getName());
    }

    private ClassManager(Class<?> clazz) {
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation getTypeLevelAnnotation(Class<? extends Annotation> annotationClass) {
        if (!this.allTypeAnnotations.containsKey(annotationClass.getName())) {
            Object object = this.monitor;
            synchronized (object) {
                for (Class<?> classInHierarchy : this.getCompleteClassHierarchy()) {
                    if (!classInHierarchy.isAnnotationPresent(annotationClass)) continue;
                    this.allTypeAnnotations.putIfAbsent(annotationClass.getName(), classInHierarchy.getAnnotation(annotationClass));
                    break;
                }
            }
        }
        return (Annotation)this.allTypeAnnotations.get(annotationClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation getPropertyLevelAnnotation(Field field, Class<? extends Annotation> annotationClass) {
        ConcurrentMap annotationMap = this.propertyAnnotations.putIfAbsent(field, new ConcurrentHashMap());
        ConcurrentMap concurrentMap = annotationMap = annotationMap != null ? annotationMap : (ConcurrentMap)this.propertyAnnotations.get(field);
        if (!annotationMap.containsKey(annotationClass.getName())) {
            Object object = this.monitor;
            synchronized (object) {
                for (Field candidateField : this.getAllPropertiesAnnotatedWith(annotationClass)) {
                    if (!field.getName().equals(candidateField.getName()) || !candidateField.isAnnotationPresent(annotationClass)) continue;
                    annotationMap.put(annotationClass.getName(), candidateField.getAnnotation(annotationClass));
                    break;
                }
                if (!annotationMap.containsKey(annotationClass.getName())) {
                    List setters;
                    List getters = (List)this.getAllGetterMethods().get(field.getName());
                    if (getters != null) {
                        for (Method candidateMethod : getters) {
                            if (!candidateMethod.isAnnotationPresent(annotationClass)) continue;
                            annotationMap.put(annotationClass.getName(), candidateMethod.getAnnotation(annotationClass));
                            break;
                        }
                    }
                    if (!annotationMap.containsKey(annotationClass.getName()) && (setters = (List)this.getAllSetterMethods().get(field.getName())) != null) {
                        for (Method candidateMethod : setters) {
                            if (!candidateMethod.isAnnotationPresent(annotationClass)) continue;
                            annotationMap.put(annotationClass.getName(), candidateMethod.getAnnotation(annotationClass));
                            break;
                        }
                    }
                }
            }
        }
        return (Annotation)((ConcurrentMap)this.propertyAnnotations.get(field)).get(annotationClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation getMethodLevelAnnotation(Method method, Class<? extends Annotation> annotationClass) {
        ConcurrentMap annotationMap = this.methodAnnotations.putIfAbsent(method, new ConcurrentHashMap());
        ConcurrentMap concurrentMap = annotationMap = annotationMap != null ? annotationMap : (ConcurrentMap)this.methodAnnotations.get(method);
        if (!annotationMap.containsKey(annotationClass.getName())) {
            Object object = this.monitor;
            synchronized (object) {
                for (Method candidateMethod : this.getAllMethodsAnnotatedWith(annotationClass)) {
                    if (!ClassUtils.isMethodExchangeableBy(method, candidateMethod)) continue;
                    annotationMap.put(annotationClass.getName(), candidateMethod.getAnnotation(annotationClass));
                    break;
                }
            }
        }
        return (Annotation)((ConcurrentMap)this.methodAnnotations.get(method)).get(annotationClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation[][] getMethodParameterAnnotations(Method method, Class<? extends Annotation> annotationClass) {
        ConcurrentMap annotationMap = this.methodParameterAnnotations.putIfAbsent(method, new ConcurrentHashMap());
        ConcurrentMap concurrentMap = annotationMap = annotationMap != null ? annotationMap : (ConcurrentMap)this.methodParameterAnnotations.get(method);
        if (!annotationMap.containsKey(annotationClass.getName())) {
            Object object = this.monitor;
            synchronized (object) {
                annotationMap.put(annotationClass.getName(), new Annotation[0][]);
                for (Class<?> clazz : this.getCompleteClassHierarchy()) {
                    block4: for (Method candidateMethod : clazz.getDeclaredMethods()) {
                        Annotation[][] annotations;
                        if (!ClassUtils.isMethodExchangeableBy(method, candidateMethod)) continue;
                        Annotation[][] arr$ = annotations = candidateMethod.getParameterAnnotations();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            Annotation[] paramAnnotations;
                            for (Annotation paramAnnotation : paramAnnotations = arr$[i$]) {
                                if (!annotationClass.equals(paramAnnotation.annotationType())) continue;
                                annotationMap.put(annotationClass.getName(), annotations);
                                continue block4;
                            }
                        }
                    }
                }
            }
        }
        return (Annotation[][])((ConcurrentMap)this.methodParameterAnnotations.get(method)).get(annotationClass.getName());
    }

    public Annotation getMethodOrTypeLevelAnnotation(Method method, Class<? extends Annotation> annotationClass) {
        Annotation methodLevelAnnotation = this.getMethodLevelAnnotation(method, annotationClass);
        return methodLevelAnnotation != null ? methodLevelAnnotation : this.getTypeLevelAnnotation(annotationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getAllMethodsAnnotatedWith(Class<? extends Annotation> annotationClass) {
        if (!this.allAnnotatedMethods.containsKey(annotationClass.getName())) {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Method> methods = new ArrayList<Method>();
                for (Class<?> classInHierarchy : this.getCompleteClassHierarchy()) {
                    for (Method methodInHierarchy : classInHierarchy.getDeclaredMethods()) {
                        if (!Modifier.isPublic(methodInHierarchy.getModifiers()) || !methodInHierarchy.isAnnotationPresent(annotationClass)) continue;
                        methods.add(methodInHierarchy);
                    }
                }
                this.allAnnotatedMethods.put(annotationClass.getName(), methods);
            }
        }
        return Collections.unmodifiableList((List)this.allAnnotatedMethods.get(annotationClass.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getAllPropertiesAnnotatedWith(Class<? extends Annotation> annotationClass) {
        if (!this.allAnnotatedProperties.containsKey(annotationClass.getName())) {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Field> annotatedFields = new ArrayList<Field>();
                for (Class<?> classInHierarchy : this.getCompleteClassHierarchy()) {
                    for (Field fieldInHierarchy : classInHierarchy.getDeclaredFields()) {
                        List setters;
                        if (fieldInHierarchy.isAnnotationPresent(annotationClass)) {
                            annotatedFields.add(fieldInHierarchy);
                            continue;
                        }
                        List getters = (List)this.getAllGetterMethods().get(fieldInHierarchy.getName());
                        if (getters != null) {
                            for (Method getter : getters) {
                                if (!getter.isAnnotationPresent(annotationClass)) continue;
                                annotatedFields.add(fieldInHierarchy);
                            }
                        }
                        if ((setters = (List)this.getAllSetterMethods().get(fieldInHierarchy.getName())) == null) continue;
                        for (Method setter : setters) {
                            if (!setter.isAnnotationPresent(annotationClass)) continue;
                            annotatedFields.add(fieldInHierarchy);
                        }
                    }
                }
                this.allAnnotatedProperties.put(annotationClass.getName(), annotatedFields);
            }
        }
        return Collections.unmodifiableList((List)this.allAnnotatedProperties.get(annotationClass.getName()));
    }

    public List<Class<?>> getClassHierarchy() {
        if (this.classHierarchy == null) {
            this.classHierarchy = Collections.unmodifiableList(ClassUtils.getClassHierarchy(this.clazz));
        }
        return this.classHierarchy;
    }

    public List<Class<?>> getInterfaceHierarchy() {
        if (this.interfaceHierarchy == null) {
            this.interfaceHierarchy = Collections.unmodifiableList(ClassUtils.getInterfaceHierarchy(this.clazz));
        }
        return this.interfaceHierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getCompleteClassHierarchy() {
        if (this.completeClassHierarchy == null) {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Class<Object>> completeClassHierarchyAssemble = new ArrayList<Class<Object>>();
                List<Class<?>> cHierarchy = this.getClassHierarchy();
                ArrayList iHierarchy = new ArrayList();
                for (Class<?> classInHierarchy : cHierarchy) {
                    for (Class<?> i : ClassManager.getInstance(classInHierarchy).getInterfaceHierarchy()) {
                        iHierarchy.add(i);
                    }
                }
                completeClassHierarchyAssemble.addAll(cHierarchy);
                completeClassHierarchyAssemble.addAll(iHierarchy);
                this.completeClassHierarchy = Collections.unmodifiableList(completeClassHierarchyAssemble);
            }
        }
        return this.completeClassHierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getCompleteClassHierarchyMethods() {
        if (this.allMethods == null) {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Method> allMethodsAssemble = new ArrayList<Method>();
                for (Class<?> classInHierarchy : this.getCompleteClassHierarchy()) {
                    allMethodsAssemble.addAll(Arrays.asList(classInHierarchy.getDeclaredMethods()));
                }
                this.allMethods = Collections.unmodifiableList(allMethodsAssemble);
            }
        }
        return this.allMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentMap<String, List<Method>> getAllGetterMethods() {
        if (this.allGetterMethods == null) {
            Object object = this.monitor;
            synchronized (object) {
                this.allGetterMethods = new ConcurrentHashMap<String, List<Method>>();
                for (Class<?> classInHierarchy : this.getCompleteClassHierarchy()) {
                    for (Method methodInHierarchy : classInHierarchy.getDeclaredMethods()) {
                        if (!Modifier.isPublic(methodInHierarchy.getModifiers())) continue;
                        String methodName = methodInHierarchy.getName();
                        String fieldName = null;
                        if (methodName.startsWith("get") && methodName.length() > 3) {
                            fieldName = methodName.replace("get", "");
                        } else if (methodName.startsWith("is") && methodName.length() > 2) {
                            fieldName = methodName.replace("is", "").toLowerCase();
                        }
                        if (fieldName == null) continue;
                        ArrayList fieldGetters = (ArrayList)this.allGetterMethods.get(fieldName = fieldName.replace(fieldName.substring(0, 1), fieldName.substring(0, 1).toLowerCase()));
                        if (fieldGetters == null) {
                            fieldGetters = new ArrayList();
                            this.allGetterMethods.put(fieldName, fieldGetters);
                        }
                        ((List)this.allGetterMethods.get(fieldName)).add(methodInHierarchy);
                    }
                }
            }
        }
        return this.allGetterMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentMap<String, List<Method>> getAllSetterMethods() {
        if (this.allSetterMethods == null) {
            Object object = this.monitor;
            synchronized (object) {
                this.allSetterMethods = new ConcurrentHashMap<String, List<Method>>();
                for (Class<?> classInHierarchy : this.getCompleteClassHierarchy()) {
                    for (Method methodInHierarchy : classInHierarchy.getDeclaredMethods()) {
                        String methodName;
                        if (!Modifier.isPublic(methodInHierarchy.getModifiers()) || !(methodName = methodInHierarchy.getName()).startsWith("set") || methodName.length() <= 3) continue;
                        String fieldName = methodName.replace("set", "");
                        ArrayList fieldSetters = (ArrayList)this.allSetterMethods.get(fieldName = fieldName.replace(fieldName.substring(0, 1), fieldName.substring(0, 1).toLowerCase()));
                        if (fieldSetters == null) {
                            fieldSetters = new ArrayList();
                            this.allSetterMethods.put(fieldName, fieldSetters);
                        }
                        ((List)this.allSetterMethods.get(fieldName)).add(methodInHierarchy);
                    }
                }
            }
        }
        return this.allSetterMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getActualReferences() {
        if (this.actualReferences == null) {
            Object object = this.monitor;
            synchronized (object) {
                LinkedList<Field> actualReferencesAssemble = new LinkedList<Field>();
                for (Class<?> clazz : this.getClassHierarchy()) {
                    for (Field field : clazz.getDeclaredFields()) {
                        if (!ReflUtils.isActualReference(field.getType())) continue;
                        actualReferencesAssemble.add(field);
                    }
                }
                this.actualReferences = Collections.unmodifiableList(actualReferencesAssemble);
            }
        }
        return this.actualReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getVirtualPrimitives() {
        if (this.virtualPrimitives == null) {
            Object object = this.monitor;
            synchronized (object) {
                LinkedList<Field> virtualPrimitivesAssemble = new LinkedList<Field>();
                for (Class<?> clazz : this.getClassHierarchy()) {
                    for (Field field : clazz.getDeclaredFields()) {
                        if (!ReflUtils.isVirtualPrimitive(field.getType())) continue;
                        virtualPrimitivesAssemble.add(field);
                    }
                }
                this.virtualPrimitives = Collections.unmodifiableList(virtualPrimitivesAssemble);
            }
        }
        return this.virtualPrimitives;
    }
}

