/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.supply.jaxb;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.annotations.Produces;
import net.craftforge.essential.supply.Producer;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class JaxbProducer
extends Producer {
    private static Object convertPropertyValue(String propertyName, String propertyValue) {
        if (propertyName.equals("jaxb.formatted.output") || propertyName.equals("jaxb.fragment")) {
            return Boolean.valueOf(propertyValue);
        }
        return propertyValue;
    }

    public JaxbProducer(Configuration config) {
        super(config);
    }

    @Produces(value={"text/xml", "application/xml"})
    public void xml(Object result, OutputStream out, String charset) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{result.getClass()});
        Marshaller marshaller = context.createMarshaller();
        for (Map.Entry<String, String> entry : this.config.getXmlSerializationProperties().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            marshaller.setProperty(key, JaxbProducer.convertPropertyValue(key, value));
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        marshaller.marshal(result, (Writer)writer);
        writer.close();
    }

    @Produces(value={"text/json", "application/json"})
    public void json(Object result, OutputStream out, String charset) throws ControllerException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector());
        for (Map.Entry<String, String> entry : this.config.getXmlSerializationProperties().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            mapper.getSerializationConfig().set(SerializationConfig.Feature.valueOf((String)key), Boolean.valueOf(value).booleanValue());
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        JsonGenerator generator = mapper.getJsonFactory().createJsonGenerator((Writer)writer);
        generator.writeObject(result);
        generator.close();
    }
}

