/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.supply.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.annotations.Consumes;
import net.craftforge.essential.supply.Consumer;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbConsumer
extends Consumer {
    public JaxbConsumer(Configuration config) {
        super(config);
    }

    @Consumes(value={"text/xml", "application/xml"})
    public Object xml(Class<?> type, InputStream input, String charset) throws JAXBException, IOException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{type});
        Unmarshaller u = jc.createUnmarshaller();
        for (String key : this.config.getXmlDeserializationProperties().keySet()) {
            String value = this.config.getXmlDeserializationProperties().get(key);
            u.setProperty(key, (Object)value);
        }
        InputStreamReader reader = new InputStreamReader(input, charset);
        Object value = u.unmarshal((Reader)reader);
        reader.close();
        return value;
    }

    @Consumes(value={"text/json", "application/json"})
    public Object json(Class<?> type, InputStream input, String charset) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector());
        for (String key : this.config.getJsonDeserializationProperties().keySet()) {
            String value = this.config.getJsonDeserializationProperties().get(key);
            mapper.getDeserializationConfig().set(DeserializationConfig.Feature.valueOf((String)key), Boolean.valueOf(value).booleanValue());
        }
        InputStreamReader reader = new InputStreamReader(input, charset);
        Object value = mapper.readValue((Reader)reader, type);
        reader.close();
        return value;
    }
}

