/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.supply;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.annotations.Produces;
import net.craftforge.essential.controller.utils.AnnotationUtils;

public class Producer {
    protected Configuration config;

    public Producer(Configuration config) {
        this.config = config;
    }

    public void produce(String accepted, Object result, OutputStream outputStream, String charset) throws ControllerException {
        Method producerMethod = AnnotationUtils.getProducerMethod(this, accepted);
        try {
            producerMethod.invoke((Object)this, result, outputStream, charset);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ControllerException) {
                throw (ControllerException)cause;
            }
            throw new ControllerException("The producer method failed during execution: " + producerMethod, cause);
        }
        catch (IllegalAccessException e) {
            throw new ControllerException("The producer method could not be invoked: " + producerMethod, e);
        }
    }

    public String getBestMatchingMediaType(String accepted) throws ControllerException {
        return AnnotationUtils.getBestMatchingMediaType(this, Produces.class, accepted);
    }

    @Produces(value={"text/plain"})
    public void plain(Object result, OutputStream out, String charset) throws IOException {
        String text = result.toString();
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(text);
        writer.close();
    }
}

