/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.supply;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.craftforge.commons.io.StreamUtils;
import net.craftforge.essential.controller.Configuration;
import net.craftforge.essential.controller.ControllerException;
import net.craftforge.essential.controller.annotations.Consumes;
import net.craftforge.essential.controller.constants.HttpStatusCode;
import net.craftforge.essential.controller.utils.AnnotationUtils;
import net.craftforge.reflection.utils.ReflUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Consumer {
    protected Configuration config;

    public Consumer(Configuration config) {
        this.config = config;
    }

    public Object consume(Class<?> clazz, String mediaType, String input) throws ControllerException {
        if (AnnotationUtils.isStreamingSupported(this, mediaType)) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(input.getBytes("UTF-8"));
                return this.consume(clazz, mediaType, inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ControllerException("Failed to read input string", e);
            }
        }
        Method method = AnnotationUtils.getConsumerMethod(this, mediaType);
        try {
            return method.invoke((Object)this, clazz, input);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ControllerException) {
                throw (ControllerException)cause;
            }
            throw new ControllerException("The consumer method failed during execution: " + method, cause);
        }
        catch (IllegalAccessException e) {
            throw new ControllerException("The consumer method could not be invoked: " + method, e);
        }
    }

    public Object consume(Class<?> clazz, String mediaType, InputStream inputStream, String charset) throws ControllerException {
        try {
            if (inputStream.available() == 0) {
                return null;
            }
            if (!AnnotationUtils.isStreamingSupported(this, mediaType)) {
                return this.consume(clazz, mediaType, StreamUtils.readStringFromInputStream(inputStream, charset));
            }
        }
        catch (IOException e) {
            throw new ControllerException("Failed to read input stream", e);
        }
        Method method = AnnotationUtils.getConsumerMethod(this, mediaType);
        try {
            return method.invoke((Object)this, clazz, inputStream, charset);
        }
        catch (IllegalAccessException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ControllerException) {
                throw (ControllerException)cause;
            }
            throw new ControllerException("The consumer method failed during execution: " + method, cause);
        }
        catch (InvocationTargetException e) {
            throw new ControllerException("The consumer method could not be invoked: " + method, e);
        }
    }

    @Consumes(value={"text/plain"})
    public Object plain(Class<?> clazz, String input) throws ControllerException, InstantiationException, InvocationTargetException, IllegalAccessException {
        if (clazz.isPrimitive()) {
            clazz = ReflUtils.primitiveToObject(clazz);
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(input);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = clazz.getMethod("valueOf", String.class);
                return method.invoke(null, input);
            }
            catch (NoSuchMethodException e1) {
                throw new ControllerException("Unable to find a convenient method to initialize object from input");
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NumberFormatException) {
                throw new ControllerException("Unable to interpret the value " + input + " as " + clazz.getSimpleName(), cause, HttpStatusCode.BadRequest);
            }
            throw e;
        }
    }
}

