/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.craftforge.essential.controller.utils.RegExUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriUtils {
    public static String slimUri(String uri) {
        if ((uri = uri.replaceAll("([^://])/+", "$1/")).endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1, uri.length());
        }
        return uri;
    }

    public static String standardUri(String uri) {
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    public static Map<String, String[]> getUrlParameters(String encoding, String uriQueryPart) throws UnsupportedEncodingException {
        uriQueryPart = uriQueryPart.replaceAll("\\[[0-9]+\\]", "");
        HashMap<String, ArrayList<String>> paramWorkingMap = new HashMap<String, ArrayList<String>>();
        for (String param : uriQueryPart.split("&")) {
            ArrayList<String> paramValues;
            String[] pair = param.split("=");
            String paramName = URLDecoder.decode(pair[0], encoding);
            String paramValue = "";
            if (pair.length == 2) {
                URLDecoder.decode(pair[1], encoding);
            }
            if ((paramValues = (ArrayList<String>)paramWorkingMap.get(paramName)) == null) {
                paramValues = new ArrayList<String>();
                paramWorkingMap.put(paramName, paramValues);
            }
            paramValues.add(paramValue);
        }
        HashMap<String, String[]> paramReturnMap = new HashMap<String, String[]>();
        for (String paramName : paramWorkingMap.keySet()) {
            List paramValues = (List)paramWorkingMap.get(paramName);
            String[] paramValueArray = new String[paramValues.size()];
            paramReturnMap.put(paramName, paramValues.toArray(paramValueArray));
        }
        return paramReturnMap;
    }

    public static String[] splitPath(String path) {
        String[] pathParts = RegExUtils.FIND_SLASH.split(path);
        if (pathParts.length == 0) {
            pathParts = new String[]{""};
        }
        return pathParts;
    }
}

