/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.utils;

import java.util.regex.Pattern;

public class RegExUtils {
    public static final String DEFAULT_REG_EX = "[^/]+?";
    public static final Pattern FIND_REG_EX_OPERATORS = Pattern.compile("([\\\\*+\\[\\]()\\$.?\\^|])");
    public static final Pattern FIND_SLASH = Pattern.compile("/");
    public static final Pattern FIND_SEMI_COLON = Pattern.compile(";");
    public static final Pattern FIND_COLON = Pattern.compile(":");
    public static final Pattern FIND_ALL_LITERALS = Pattern.compile("[a-zA-Z0-9]");
    public static final Pattern FIND_ALL_NONE_LITERALS = Pattern.compile("[^a-zA-Z0-9]");
    public static final Pattern FIND_CURLY_BRACKETS = Pattern.compile("[\\{\\}]");
    public static final Pattern FIND_ENCLOSED_BY_CURLY_BRACKETS = Pattern.compile("\\{.*\\}");
    public static final Pattern FIND_HEADER = Pattern.compile("\\[header:(.+)\\]");
    public static final Pattern FIND_CHARSET = Pattern.compile("charset\\s*=\\s*(\\S+)");
    public static final Pattern FIND_NO_EQUAL_CONTAINED = Pattern.compile("^[^=]+$");

    public static String getRegExFromPathPart(String pathPart) {
        String regEx;
        if (FIND_ENCLOSED_BY_CURLY_BRACKETS.matcher(pathPart).matches()) {
            if (FIND_COLON.matcher(pathPart).find()) {
                String[] paramParts = pathPart.split(":");
                regEx = FIND_CURLY_BRACKETS.matcher(paramParts[1]).replaceAll("");
            } else {
                regEx = DEFAULT_REG_EX;
            }
        } else {
            regEx = FIND_REG_EX_OPERATORS.matcher(pathPart).replaceAll("\\\\$");
        }
        return regEx;
    }

    public static String[] getValuesFromPathPart(String pathPart) {
        return FIND_SEMI_COLON.split(pathPart);
    }

    public static String getParamNameFromPathPart(String pathPart, boolean withCurlyBrackets) {
        String paramNamePart = pathPart.contains(":") ? pathPart.split(":")[0] : pathPart;
        paramNamePart = FIND_CURLY_BRACKETS.matcher(paramNamePart).replaceAll("");
        return withCurlyBrackets ? "{" + paramNamePart + "}" : paramNamePart;
    }

    public static String getParamNameFromPathPart(String pathPart) {
        return RegExUtils.getParamNameFromPathPart(pathPart, true);
    }
}

