/*
 * Decompiled with CFR 0.152.
 */
package net.craftforge.essential.controller.utils;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.craftforge.commons.collections.CaseInsensitiveMap;
import net.craftforge.essential.controller.utils.RegExUtils;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderUtils {
    public static String getBasicAuthorizationHeader(String username, String password) {
        String authPair = username + ":" + password;
        return "Basic " + new String(Base64.encodeBase64((byte[])authPair.getBytes()));
    }

    public static String[] getAuthorizationPair(String[] authorizationHeaders) {
        if (authorizationHeaders == null || authorizationHeaders.length < 1 || authorizationHeaders[0] == null) {
            return new String[]{null, null};
        }
        String authorizationHeader = authorizationHeaders[0];
        StringTokenizer st = new StringTokenizer(authorizationHeader);
        String basic = st.nextToken();
        if (basic == null || !basic.equalsIgnoreCase("Basic")) {
            return new String[]{null, null};
        }
        String credentials = st.nextToken();
        String userPass = new String(Base64.decodeBase64((String)credentials));
        int pivot = userPass.indexOf(":");
        if (pivot == -1) {
            return new String[]{null, null};
        }
        String user = userPass.substring(0, pivot);
        String pass = userPass.substring(pivot + 1);
        return new String[]{user, pass};
    }

    public static String[] getContentTypePair(String contentTypeHeader) {
        if (contentTypeHeader == null || contentTypeHeader.isEmpty()) {
            return new String[]{null, null};
        }
        if (!contentTypeHeader.contains(";")) {
            return new String[]{contentTypeHeader.trim(), null};
        }
        int pivot = contentTypeHeader.indexOf(";");
        String mediaType = contentTypeHeader.substring(0, pivot).trim();
        String charsetCandidate = contentTypeHeader.substring(pivot + 1).trim();
        String charset = null;
        if (RegExUtils.FIND_CHARSET.matcher(charsetCandidate).matches()) {
            charset = RegExUtils.FIND_CHARSET.matcher(charsetCandidate).replaceAll("$1");
        } else if (RegExUtils.FIND_NO_EQUAL_CONTAINED.matcher(charsetCandidate).matches()) {
            charset = charsetCandidate;
        }
        return new String[]{mediaType, charset};
    }

    public static Map<String, String[]> normalizeHeaderMap(Map<String, List<String>> inputMap) {
        CaseInsensitiveMap<String[]> normalizedMap = new CaseInsensitiveMap<String[]>();
        for (String headerName : inputMap.keySet()) {
            List<String> headerValueList = inputMap.get(headerName);
            String[] headerValues = headerValueList.toArray(new String[headerValueList.size()]);
            normalizedMap.put(headerName, headerValues);
        }
        return normalizedMap;
    }
}

